/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.modify.style;

import au.com.ordermate.guicore.NameDecorator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.gui.modify.ComponentListener;
import ordermate.guicore.StyleRule;

public class StyleListener
implements ComponentListener {
    private Map<String, List<StyleRule>> ruleMap = new HashMap<String, List<StyleRule>>();

    public void addRule(StyleRule toAdd) {
        List<Object> rules;
        if (!this.ruleMap.containsKey(toAdd.getName())) {
            rules = new ArrayList();
            this.ruleMap.put(toAdd.getName(), rules);
        } else {
            rules = this.ruleMap.get(toAdd.getName());
        }
        rules.add(toAdd);
    }

    public void clearRules() {
        this.ruleMap.clear();
    }

    @Override
    public void componentAdded(Component comp) {
        if (this.styleBasedOnComponentName(comp)) {
            return;
        }
        this.styleBasedOnDecoratorKey(comp);
    }

    private boolean styleBasedOnComponentName(Component comp) {
        if (comp.getName() != null && this.ruleMap.containsKey(comp.getName())) {
            return this.applyStyle(comp, comp.getName());
        }
        return false;
    }

    private boolean styleBasedOnDecoratorKey(Component comp) {
        NameDecorator nameDecorator;
        if (comp instanceof NameDecorator && this.ruleMap.containsKey((nameDecorator = (NameDecorator)comp).getKey())) {
            return this.applyStyle(comp, nameDecorator.getKey());
        }
        return false;
    }

    private boolean applyStyle(Component comp, String key) {
        boolean ruleApplied = false;
        for (StyleRule rule : this.ruleMap.get(key)) {
            if (!rule.matches(comp)) continue;
            rule.style(comp);
            ruleApplied = true;
        }
        return ruleApplied;
    }

    @Override
    public void componentRemoved(Component comp) {
    }
}

