/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.ordering;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.ordering.AbstractAutoAssignComboGroupStrategy;
import ordermate.gui.ordering.OrderComboHelper;

public class DefaultAutoAssignComboGroupStrategy
extends AbstractAutoAssignComboGroupStrategy {
    public DefaultAutoAssignComboGroupStrategy(OrderComboHelper helper) {
        super(helper);
    }

    @Override
    public void assignItemsToComboGroups(List<SalesItem> newItemList, InventoryCombo combo) {
        SalesItem currSalesItem;
        SalesLineItem currItem;
        int index;
        SalesQuantity currentMin;
        List<? extends SalesLineItem> matchedItems;
        HashMap<InventoryComboGroup, SalesQuantity> currentAssignedQtys = new HashMap<InventoryComboGroup, SalesQuantity>();
        ArrayList<SalesItem> remainingItem = new ArrayList<SalesItem>(newItemList);
        for (InventoryComboGroup group : combo.getGroups()) {
            matchedItems = group.getMatchedItems(newItemList);
            currentMin = SalesQuantity.ZERO;
            for (index = 0; currentMin.lessThan(group.getMinQuantity()) && index < matchedItems.size(); ++index) {
                currItem = matchedItems.get(index);
                if (!(currItem instanceof SalesItem)) continue;
                currSalesItem = (SalesItem)currItem;
                if (currSalesItem.getInventoryComboGroup() == null) {
                    this.getHelper().setComboGroup(currSalesItem, group);
                    currentMin = currentMin.add(currSalesItem.getQuantity());
                    remainingItem.remove(currSalesItem);
                    continue;
                }
                OrderMate.LOG.warn("Unexpected assigning of a InventoryComboGroup to a SalesItem - where the salesItem has a InventorycomboGroup of " + currSalesItem.getInventoryComboGroup() + ". Item: " + currSalesItem);
            }
            currentAssignedQtys.put(group, currentMin);
        }
        if (!remainingItem.isEmpty()) {
            for (InventoryComboGroup group : combo.getGroups()) {
                if (group.getMaxQuantity().greaterThan(group.getMinQuantity())) continue;
                matchedItems = group.getMatchedItems(remainingItem);
                currentMin = (SalesQuantity)currentAssignedQtys.get(group);
                index = 0;
                while (currentMin.lessThan(group.getMaxQuantity())) {
                    currItem = matchedItems.get(index);
                    if (currItem instanceof SalesItem) {
                        currSalesItem = (SalesItem)currItem;
                        if (currSalesItem.getInventoryComboGroup() == null) {
                            this.getHelper().setComboGroup(currSalesItem, group);
                            currentMin = currentMin.add(currSalesItem.getQuantity());
                            remainingItem.remove(currSalesItem);
                        } else {
                            OrderMate.LOG.warn("Unexpected assigning of a InventoryComboGroup to a SalesItem - where the salesItem has a InventorycomboGroup of " + currSalesItem.getInventoryComboGroup() + ". Item: " + currSalesItem);
                        }
                    }
                    ++index;
                }
            }
        }
        if (!remainingItem.isEmpty()) {
            OrderMate.LOG.error("Tried to autoAssignComboGroupsToItems with an list of items had excessive items! " + ((Object)remainingItem).toString());
        }
    }
}

