/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.ordering;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountItemsHelper;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.gui.ordering.AutoAssignComboGroupStrategy;
import ordermate.gui.ordering.DefaultAutoAssignComboGroupStrategy;

public final class OrderComboHelper {
    private final GuiHandler gui;
    private AutoAssignComboGroupStrategy strategy;

    public OrderComboHelper(GuiHandler handler) {
        this.gui = handler;
        this.strategy = new DefaultAutoAssignComboGroupStrategy(this);
    }

    public SalesQuantity doOverOrderedComboItems(InventoryItem item, InventoryComboGroup comboGroup, SalesQuantity totalOrderedQty, List<SalesItem> comboItems, SalesQuantity quantity, boolean isIncrementQty) {
        SalesQuantity newQty = quantity;
        boolean userWarned = false;
        if (quantity.greaterThan(comboGroup.getMaxQuantity())) {
            if (comboGroup.getMaxQuantity().compareTo(SalesQuantity.ONE) >= 0) {
                this.gui.displayOkDialog("Too many items ordered", "This combo is limited to " + comboGroup.getMaxQuantity() + " of this group.");
            }
            newQty = comboGroup.getMaxQuantity();
            userWarned = true;
        }
        SalesQuantity existingOrderedItemQty = SalesQuantity.ZERO;
        boolean handledOverOrder = false;
        for (SalesItem currentSalesItem : comboItems) {
            for (SalesComponent currentComp : currentSalesItem.getComponentList()) {
                InventoryItem currentItem = currentComp.getInventoryItem();
                if (!currentItem.equals(item)) continue;
                existingOrderedItemQty = existingOrderedItemQty.add(currentSalesItem.getQuantity());
                if (totalOrderedQty.equals(comboGroup.getMaxQuantity()) && isIncrementQty) {
                    newQty = SalesQuantity.ONE.negate();
                    handledOverOrder = true;
                    continue;
                }
                if (totalOrderedQty.greaterThan(comboGroup.getMaxQuantity())) {
                    SalesQuantity diff = totalOrderedQty.subtract(comboGroup.getMaxQuantity());
                    newQty = diff.lessThanOrEquals(currentSalesItem.getEquivalentItemsTotalQuantity(comboItems)) ? diff.negate() : currentSalesItem.getEquivalentItemsTotalQuantity(comboItems).negate();
                    handledOverOrder = true;
                    continue;
                }
                if (isIncrementQty) continue;
                SalesQuantity newTotalOrderedQty = totalOrderedQty.subtract(currentSalesItem.getEquivalentItemsTotalQuantity(comboItems)).add(newQty);
                newQty = newQty.subtract(currentSalesItem.getEquivalentItemsTotalQuantity(comboItems));
                if (!newTotalOrderedQty.lessThanOrEquals(comboGroup.getMaxQuantity())) continue;
                handledOverOrder = true;
            }
            if (handledOverOrder || !existingOrderedItemQty.add(newQty).greaterThan(comboGroup.getMaxQuantity())) continue;
            newQty = comboGroup.getMaxQuantity().subtract(existingOrderedItemQty);
            if (!userWarned) {
                this.gui.displayOkDialog("Cannot order this amount.", "This combo is limited to " + comboGroup.getMaxQuantity() + " of this group.");
            }
            return newQty;
        }
        if (existingOrderedItemQty.equals(0L) && totalOrderedQty.greaterThanOrEquals(comboGroup.getMaxQuantity())) {
            if (comboGroup.getMaxQuantity().equals(1L)) {
                comboItems.removeAll(comboGroup.getMatchedItems(comboItems));
                newQty = SalesQuantity.ONE;
            } else {
                newQty = SalesQuantity.ZERO;
                this.gui.displayOkDialog("Cannot order this amount.", "This combo is limited to " + comboGroup.getMaxQuantity() + " items from this group.  Select an item to remove.");
                userWarned = true;
            }
        }
        return newQty;
    }

    public List<SalesItem> getAllItemsFromMap(Map<InventoryComboGroup, List<SalesItem>> map) {
        ArrayList<SalesItem> allItems = new ArrayList<SalesItem>();
        for (List<SalesItem> lists : map.values()) {
            allItems.addAll(lists);
        }
        return allItems;
    }

    public void addItemsToGroupMap(Map<InventoryComboGroup, List<SalesItem>> comboListMap, List<SalesItem> toAdd) {
        for (InventoryComboGroup group : comboListMap.keySet()) {
            List<? extends SalesLineItem> localToAdd = group.getMatchedItems(toAdd);
            if (localToAdd == null || localToAdd.isEmpty()) continue;
            List<SalesItem> oldList = comboListMap.get(group);
            oldList.removeAll(localToAdd);
            oldList.addAll(0, localToAdd);
            comboListMap.put(group, oldList);
            toAdd.removeAll(localToAdd);
        }
    }

    public void setComboGroup(SalesItem newItem, InventoryComboGroup theComboGroup) {
        newItem.setInventoryComboGroup(theComboGroup);
    }

    public void autoAssignComboGroupsToItems(InventoryCombo combo, List<SalesItem> newItemList) {
        if (!combo.matchesItems(newItemList)) {
            OrderMate.LOG.error("Tried to autoAssignComboGroupsToItems with an list of items that were not matched to the combo!");
            return;
        }
        this.strategy.assignItemsToComboGroups(newItemList, combo);
    }

    public void replaceItems(Account acc, SalesCombo comboToInsert, Terminal term, User usr) {
        ArrayList<SalesItem> newItemList = new ArrayList<SalesItem>();
        HashSet<SalesItem> itemsCounted = new HashSet<SalesItem>();
        boolean ignoreSeat = !SystemProperty.getInstance().isCustomerAssignmentPerSeat();
        for (SalesItem currentComboItem : comboToInsert.getSalesItems()) {
            SalesQuantity comboItemQtyRemaining = currentComboItem.getQuantity();
            boolean localSuccess = false;
            for (SalesItem currentItem : acc.getItemHelper().getSalesItems()) {
                if (itemsCounted.contains(currentItem) || !currentItem.isEquivalentTo(currentComboItem, true, ignoreSeat)) continue;
                itemsCounted.add(currentItem);
                newItemList.add(currentItem);
                if (currentItem.getQuantity().lessThan(comboItemQtyRemaining)) {
                    comboItemQtyRemaining = comboItemQtyRemaining.subtract(currentItem.getQuantity());
                    continue;
                }
                if (currentItem.getQuantity().equals(comboItemQtyRemaining)) {
                    comboItemQtyRemaining = comboItemQtyRemaining.subtract(currentItem.getQuantity());
                    localSuccess = true;
                    break;
                }
                currentItem.split(currentItem.getQuantity().subtract(comboItemQtyRemaining), new EventContext(term, usr));
                localSuccess = true;
                break;
            }
            if (localSuccess) continue;
            throw new IllegalStateException("Unable to replace items in the account with this combo, not all requisite items in this account to be replaced.");
        }
        this.autoAssignComboGroupsToItems(comboToInsert.getCombo(), newItemList);
        SalesCombo accountCombo = comboToInsert.getCombo().createSalesCombo(newItemList, comboToInsert.getQuantity(), term, usr);
        accountCombo.courseChanged();
        acc.getItemHelper().addItem(accountCombo);
    }

    public void replaceCombo(Account account, SalesCombo comboToReplace, Terminal term, User usr) {
        if (comboToReplace.hasFinanceTransactions()) {
            throw new IllegalArgumentException("Cannot split up this combo, it has been paid for.");
        }
        for (SalesItem item : comboToReplace.getSalesItems()) {
            item.setCombo(null);
            this.setComboGroup(item, null);
            item.resetToOriginalPrice();
            new AccountItemsHelper(account).addActiveItems(item);
        }
        comboToReplace.removeAllItems();
        account.getItemHelper().removeItem(comboToReplace, new EventContext(term, usr));
    }

    public void orderDefaultItems(Map<InventoryComboGroup, List<SalesItem>> orderedItemMap, TriggerActivationContext context) {
        block0: for (Map.Entry<InventoryComboGroup, List<SalesItem>> entry : orderedItemMap.entrySet()) {
            for (InventoryComboGroupItemUnitLink link : entry.getKey().getGroupUnitLink()) {
                if (link.getDefaultQty() == null || !link.getDefaultQty().greaterThan(SalesQuantity.ZERO) || !link.getItemUnit().isPubliclyAccessible()) continue;
                SalesQuantity qtyToOrder = link.getDefaultQty();
                if (entry.getKey().getMaxQuantity() != null) {
                    SalesQuantity max = entry.getKey().getMaxQuantity();
                    if (!entry.getValue().isEmpty()) {
                        for (SalesItem item : entry.getValue()) {
                            max = max.subtract(item.getQuantity());
                        }
                    }
                    if (qtyToOrder.greaterThan(max)) {
                        qtyToOrder = max;
                    }
                }
                if (!qtyToOrder.greaterThan(SalesQuantity.ZERO)) continue block0;
                InventoryItemUnit unit = link.getItemUnit();
                UnitPriceLevel priceLevel = unit.getActiveUnitPriceLevel(context, new Date(), context.getAccount());
                if (priceLevel == null) continue;
                SalesItem newItem = new SalesItem(Terminal.getLocalHost(), context.getUser());
                newItem.setQuantity(qtyToOrder, context);
                newItem.createComponent(unit, priceLevel);
                newItem.setCourse(entry.getKey().getItemCourse(unit.getItem()));
                entry.getValue().add(newItem);
            }
        }
    }
}

