/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.reservation;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import java.util.Date;
import java.util.List;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.queries.tables.LogicalTableQueries;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.RDContextGrabber;

public class ReservationUtils {
    private final GuiHandler handler;
    private RDContext rdContext;

    public ReservationUtils(GuiHandler handler) {
        this.handler = handler;
        if (RDConfiguration.checkConfigured()) {
            this.rdContext = PersistenceManager.getServerConnection().runSync(new RDContextGrabber());
        }
    }

    public boolean isTableSelectable(LogicalTable table) {
        List<Reservation> overlappedReservations;
        if (RDConfiguration.checkConfigured() && (overlappedReservations = ReservationsHelper.getOverlappedReservations(table, this.getRDContext().getTimeSlotInterval(new Date()))) != null && !overlappedReservations.isEmpty()) {
            this.displayOverlappedMsgDialog(ReservationsHelper.getOverlappedReservationsMsg(overlappedReservations, null));
            return false;
        }
        return true;
    }

    public boolean isTableSelectable(String tableNames, TableGroup tableGroup, Date date, Date arrivalTime, Date leaveTime, Reservation reservation) {
        String overlappedReservationMsg;
        if (tableGroup == null || tableNames == null) {
            this.handler.displayOkDialog(HtmlUtils.html("Please select correct table & section!"), "Please select table.");
        }
        if (!(overlappedReservationMsg = ReservationsHelper.getOverlappedReservationsMsg(ReservationsHelper.getOverlappedReservations(tableNames, tableGroup, date, arrivalTime, leaveTime), reservation)).isEmpty()) {
            this.displayOverlappedMsgDialog(overlappedReservationMsg);
            return false;
        }
        return true;
    }

    private void displayOverlappedMsgDialog(String overlappedReservationMsg) {
        this.handler.displayOkDialog(HtmlUtils.html("RestaurantDiary has " + overlappedReservationMsg), "Please select another table or update booking(s).");
    }

    public boolean isTableSelectable(LogicalTable table, Reservation reservation) {
        if (table.hasAccount()) {
            Reservation tableReservation;
            if (RDConfiguration.checkConfigured() && (tableReservation = ReservationsHelper.getReservation(table.getAccount(), null)) != null && DateTimeUtils.timeIsAfter(reservation.getTime(), tableReservation.getLeaveTime())) {
                return true;
            }
            this.displayCurrentlyInUse(table);
            return false;
        }
        return true;
    }

    public void displayCurrentlyInUse(LogicalTable table) {
        this.handler.displayOkDialog(HtmlUtils.html("Cannot assign a reservation to table " + HtmlUtils.boldColor(LogicalTableQueries.getTableNames(table), "green") + " which is currently in use"), "Please select another table.");
    }

    public void displayTableDoesntExist(String tables, TableGroup section) {
        this.handler.displayOkDialog(HtmlUtils.html("There is no table for the given table: " + HtmlUtils.boldColor(tables, "green") + " and section: " + HtmlUtils.boldColor(section != null ? section.getName() : "", "green")), "Please select another table.");
    }

    public void displayCurrentlyLocked(LogicalTable table) {
        this.handler.displayOkDialog(HtmlUtils.html("Cannot assign a reservation to table " + HtmlUtils.boldColor(LogicalTableQueries.getTableNames(table), "green") + " because it is locked. Please unlock first."), "Please unlock table.");
    }

    public RDContext getRDContext() {
        if (this.rdContext == null) {
            this.rdContext = PersistenceManager.getServerConnection().runSync(new RDContextGrabber());
        }
        return this.rdContext;
    }

    public Reservation getNextReservation(LogicalTable table) {
        List<Reservation> reservationList = ReservationsHelper.getUnarrivedReservations(new Date(), table);
        return reservationList.isEmpty() ? null : reservationList.get(0);
    }
}

