/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.ScrollPaneModelEvent;
import ordermate.gui.scroll.ScrollPaneModelListener;

public abstract class AbstractScrollPaneModel
implements CustomScrollPaneModel {
    private static final int DEFAULT_COLUMNS = 3;
    private static final int DEFAULT_ROWS = 5;
    protected int[] colWidths;
    protected boolean customWidths;
    protected int numColumns = 1;
    protected int rowsPerPage;
    protected List<ScrollPaneModelListener> listeners = new ArrayList<ScrollPaneModelListener>();
    private int startPage;
    private int endPage;

    public AbstractScrollPaneModel() {
        this(3, 5);
    }

    public AbstractScrollPaneModel(int columns, int numRowsPerPage) {
        this.rowsPerPage = numRowsPerPage;
        this.customWidths = false;
        this.numColumns = columns;
    }

    public AbstractScrollPaneModel(int[] widths, int numRowsPerPage) {
        this.colWidths = widths;
        this.rowsPerPage = numRowsPerPage;
        this.customWidths = true;
        this.numColumns = this.colWidths.length;
    }

    @Override
    public abstract int getSize();

    protected abstract Component getComponent(int var1);

    @Override
    public int[] getColumnWidths() {
        return this.colWidths;
    }

    @Override
    public int getColumns() {
        return this.numColumns;
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.getSize() / (double)this.numColumns);
    }

    @Override
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Override
    public void setColumns(int newColumns) {
        int start = 0;
        int end = this.getPageCount() - 1;
        this.customWidths = false;
        this.numColumns = newColumns;
        this.fireModelEvent(start, end, this.getPageCount());
    }

    @Override
    public void setRowsPerPage(int newRowsPerPage) {
        int start = 0;
        int end = this.getPageCount() - 1;
        this.rowsPerPage = newRowsPerPage;
        this.fireModelEvent(start, end, this.getPageCount());
    }

    @Override
    public int getPageCount() {
        int pageCount = (int)Math.ceil((double)this.getRows() / (double)this.rowsPerPage);
        if (pageCount < 1) {
            pageCount = 1;
        }
        return pageCount;
    }

    @Override
    public List getComponentsForPageNumber(int page) {
        if (!this.hasPageNumber(page)) {
            return new ArrayList();
        }
        int firstComponent = page * (this.rowsPerPage * this.numColumns);
        int lastComponent = firstComponent + this.rowsPerPage * this.numColumns;
        if (lastComponent >= this.getSize()) {
            lastComponent = this.getSize();
        }
        ArrayList<Component> componentList = new ArrayList<Component>();
        for (int i = firstComponent; i < lastComponent; ++i) {
            componentList.add(this.getComponent(i));
        }
        return componentList;
    }

    @Override
    public void addScrollPaneModelListener(ScrollPaneModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeScrollPaneModelListener(ScrollPaneModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean hasPageNumber(int page) {
        int firstComponent = page * (this.rowsPerPage * this.numColumns);
        boolean tooBig = firstComponent >= this.getSize();
        boolean tooSmall = page < 0;
        return !tooBig && !tooSmall;
    }

    protected final void fireModelEvent(int theStartPage, int theEndPage, int numPages) {
        ScrollPaneModelEvent event = new ScrollPaneModelEvent(this, theStartPage, theEndPage, numPages);
        for (ScrollPaneModelListener listener : this.listeners) {
            listener.paneChanged(event);
        }
    }

    protected final void preListChange() {
        this.startPage = 0;
        this.endPage = this.getPageCount() - 1;
        if (this.endPage < 0) {
            this.endPage = 0;
        }
    }

    protected final void postListChange() {
        int numPages = this.getPageCount();
        this.fireModelEvent(this.startPage, this.endPage, numPages);
    }

    public final void refresh() {
        if (this.getSize() != 0) {
            int numPages = this.getPageCount();
            this.fireModelEvent(0, numPages, numPages);
        }
    }

    @Override
    public boolean customWidths() {
        return this.customWidths;
    }

    public static List<JButton> constructButtons(String[] buttonText, int width, int height) {
        return AbstractScrollPaneModel.constructButtons(Arrays.asList(buttonText), width, height);
    }

    public static List<JButton> constructButtons(List<String> buttonText, int width, int height) {
        ArrayList<JButton> buttons = new ArrayList<JButton>(buttonText.size());
        for (int i = 0; i < buttonText.size(); ++i) {
            JButton newButton = new JButton(buttonText.get(i));
            newButton.setPreferredSize(new Dimension(width, height));
            buttons.add(newButton);
        }
        return buttons;
    }

    public static List<JButton> constructButtons(String[] buttonText) {
        return AbstractScrollPaneModel.constructButtons(buttonText, 200, 50);
    }

    public static List<CustomButton> constructButtons(Collection<? extends Displayable> displayableItems) {
        ArrayList<CustomButton> buttons = new ArrayList<CustomButton>();
        for (Displayable displayable : displayableItems) {
            CustomButton<Displayable> button = new CustomButton<Displayable>(displayable);
            button.setPreferredSize(new Dimension(200, 50));
            buttons.add(button);
        }
        return buttons;
    }

    public static JButton constructButton(String icon, String text, String name) {
        JButton toSetup = new JButton();
        toSetup.setIcon(new ImageIcon(AbstractScrollPaneModel.class.getResource(icon)));
        toSetup.setHorizontalTextPosition(0);
        toSetup.setVerticalTextPosition(3);
        toSetup.setText(text);
        toSetup.setName(name);
        return toSetup;
    }
}

