/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import java.awt.Point;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.ScrollPaneModelListener;

public class ComponentScrollPaneModel
implements CustomScrollPaneModel {
    private int pixelsPerRow = 40;
    private JComponent wrappedComponent;
    private JViewport viewport;
    private List compList;

    public ComponentScrollPaneModel(JComponent component) {
        this(component, 40);
    }

    public ComponentScrollPaneModel(JComponent component, int numPixelsPerRow) {
        this.wrappedComponent = component;
        this.pixelsPerRow = numPixelsPerRow;
        this.viewport = new JViewport();
        this.viewport.setView(component);
        this.viewport.setOpaque(false);
        this.compList = Collections.singletonList(this.viewport);
    }

    @Override
    public int[] getColumnWidths() {
        return null;
    }

    @Override
    public void setColumns(int columns) {
        throw new IllegalStateException("Cannot set the number of columns for a Component scroll pane");
    }

    @Override
    public int getColumns() {
        return 1;
    }

    @Override
    public boolean customWidths() {
        return false;
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((this.wrappedComponent.getSize().height - this.viewport.getSize().height) / this.pixelsPerRow) + 1;
    }

    @Override
    public int getSize() {
        return this.getRows();
    }

    @Override
    public void setRowsPerPage(int rowsPerPage) {
    }

    @Override
    public int getRowsPerPage() {
        return 1;
    }

    @Override
    public int getPageCount() {
        return this.getRows();
    }

    @Override
    public boolean hasPageNumber(int page) {
        if (page < 0) {
            return false;
        }
        if (page == 0) {
            return true;
        }
        if (this.wrappedComponent.getSize().height == 0) {
            return true;
        }
        int totalPages = (int)Math.ceil((this.wrappedComponent.getSize().height - this.viewport.getSize().height) / this.pixelsPerRow) + 1;
        return totalPages >= page;
    }

    @Override
    public List getComponentsForPageNumber(int page) {
        Point point = new Point(0, this.pixelsPerRow * page);
        this.wrappedComponent.validate();
        this.viewport.setViewPosition(point);
        return this.compList;
    }

    @Override
    public void addScrollPaneModelListener(ScrollPaneModelListener l) {
    }

    @Override
    public void removeScrollPaneModelListener(ScrollPaneModelListener l) {
    }
}

