/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import au.com.ordermate.persistence.Displayable;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class CustomButtonRenderer<T extends Displayable>
implements Renderer<CustomButton<T>, T> {
    public final Signal<T, ?, ?, ?, ?> selected = Signals.createSignal(this.getSelectedClassType(), "selectedItem");

    @Override
    public CustomButton<T> createComponent() {
        final CustomButton button = new CustomButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object data = button.getData();
                CustomButtonRenderer.this.selected.emit(data);
            }
        });
        button.setPreferredSize(new Dimension(140, 70));
        button.setHorizontalAlignment(2);
        button.setHorizontalTextPosition(2);
        return button;
    }

    @Override
    public void setupComponent(CustomButton<T> component, T object, int index) {
        component.setText(this.createComponentText(object));
        component.setInfo(object);
    }

    protected String createComponentText(T object) {
        return object.getLabel();
    }

    public abstract Class<T> getSelectedClassType();
}

