/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.scroll.PageChangeEvent;
import ordermate.gui.scroll.PageChangeListener;
import ordermate.gui.scroll.ScrollPaneModelEvent;
import ordermate.gui.scroll.ScrollPaneModelListener;

public class CustomScrollPane
extends JPanel
implements ActionListener,
ScrollPaneModelListener,
MouseWheelListener {
    private static final int DEFAULT_PADDING = 2;
    private JButton previousButton;
    private JButton nextButton;
    private JPanel centerPanel;
    protected CustomScrollPaneModel model;
    private int currentPage = 0;
    private List currentComponents;
    private int padding = 2;
    private Boolean enabled = null;
    private List<PageChangeListener> pageChangeListeners;
    private JPanel messagePanel;
    private JLabel message;
    private GraphPaperLayout layoutManager;
    private DecoratorLocation decorationLocation = DecoratorLocation.NorthSouth;
    private boolean decoratorAlwaysVisible = false;

    public CustomScrollPane() {
        this(new DefaultScrollPaneModel());
    }

    public CustomScrollPane(List<? extends Component> components) {
        this(new DefaultScrollPaneModel());
        ((DefaultScrollPaneModel)this.model).setItems(components);
    }

    public CustomScrollPane(CustomScrollPaneModel newModel) {
        this(newModel, 2);
    }

    public void setCenterBorder(Border value) {
        this.centerPanel.setBorder(value);
    }

    public CustomScrollPane(CustomScrollPaneModel newModel, int newPadding) {
        this.padding = newPadding;
        this.messagePanel = new JPanel(new BorderLayout());
        this.message = new JLabel("", 0);
        this.messagePanel.add((Component)this.message, "Center");
        this.setModel(newModel);
        this.init();
        this.displayPage(0);
        this.addMouseWheelListener(this);
    }

    public void removeMouseWheelListener() {
        this.removeMouseWheelListener(this);
    }

    public CustomScrollPane(CustomScrollPaneModel newModel, String upArrow, String downArrow) {
        this(newModel);
        ImageIcon upIcon = IconLoader.get(upArrow);
        ImageIcon downIcon = IconLoader.get(downArrow);
        this.setModel(newModel);
        this.init(upIcon, downIcon);
        this.displayPage(0);
    }

    private void init() {
        String upArrow = UIManager.getString("CustomScrollPane.upArrow");
        ImageIcon upIcon = upArrow == null ? IconLoader.get("/ordermate/images/uparrow.png") : IconLoader.get(upArrow);
        String downArrow = UIManager.getString("CustomScrollPane.downArrow");
        ImageIcon downIcon = downArrow == null ? IconLoader.get("/ordermate/images/downarrow.png") : IconLoader.get(downArrow);
        this.init(upIcon, downIcon);
    }

    private void init(Icon upArrow, Icon downArrow) {
        this.setLayout(new BorderLayout());
        this.previousButton = new JButton(upArrow);
        this.previousButton.addActionListener(this);
        this.nextButton = new JButton(downArrow);
        this.nextButton.addActionListener(this);
        this.installScrollButtons();
        this.setupCenterPanel(this.model.getRowsPerPage(), this.model.getColumns());
        this.currentComponents = new ArrayList();
        this.pageChangeListeners = new ArrayList<PageChangeListener>();
    }

    private void installScrollButtons() {
        if (DecoratorLocation.West.equals((Object)this.decorationLocation) || DecoratorLocation.East.equals((Object)this.decorationLocation)) {
            JPanel holder = new JPanel(new GridLayout(2, 1));
            holder.add(this.previousButton);
            holder.add(this.nextButton);
            if (this.decorationLocation.equals((Object)DecoratorLocation.West)) {
                this.add((Component)holder, "West");
            } else {
                this.add((Component)holder, "East");
            }
            holder.setOpaque(this.isOpaque());
        } else if (DecoratorLocation.EastWest.equals((Object)this.decorationLocation)) {
            this.add((Component)this.previousButton, "West");
            this.add((Component)this.nextButton, "East");
        } else {
            this.add((Component)this.previousButton, "North");
            this.add((Component)this.nextButton, "South");
        }
    }

    private void removeScrollButtons() {
        if (this.decorationLocation.equals((Object)DecoratorLocation.West) || this.decorationLocation.equals((Object)DecoratorLocation.East)) {
            JPanel holder = (JPanel)this.previousButton.getParent();
            holder.remove(this.previousButton);
            holder.remove(this.nextButton);
            this.remove(holder);
        } else {
            this.remove(this.previousButton);
            this.remove(this.nextButton);
        }
    }

    public void setDecorationLocation(DecoratorLocation value) {
        if (value == null) {
            return;
        }
        this.removeScrollButtons();
        this.decorationLocation = value;
        this.installScrollButtons();
    }

    public void setDecoratorAlwaysVisible(boolean value) {
        this.decoratorAlwaysVisible = value;
    }

    public final DecoratorLocation getDecorationLocation() {
        return this.decorationLocation;
    }

    private void setupCenterPanel(int rows, int cols) {
        if (this.centerPanel != null) {
            this.remove(this.centerPanel);
        }
        this.layoutManager = this.model.customWidths() ? new GraphPaperLayout(new Dimension(100, rows)) : new GraphPaperLayout(new Dimension(cols, rows), this.padding, this.padding);
        this.centerPanel = new JPanel(this.layoutManager);
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.setOpaque(this.isOpaque());
    }

    public CustomScrollPaneModel getModel() {
        return this.model;
    }

    public int getPageCount() {
        return this.model.getPageCount();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.setupCenterPanel(rowsPerPage, this.model.getColumns());
        this.getModel().setRowsPerPage(rowsPerPage);
    }

    public int getRowsPerPage() {
        return this.getModel().getRowsPerPage();
    }

    public void setColumns(int columns) {
        this.setupCenterPanel(this.model.getRowsPerPage(), columns);
        this.getModel().setColumns(columns);
    }

    public int getColumns() {
        return this.getModel().getColumns();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        if (this.centerPanel != null) {
            this.centerPanel.setOpaque(isOpaque);
        }
        super.setOpaque(isOpaque);
    }

    public boolean gotoComponent(Object comp) {
        int numPages = this.model.getPageCount();
        boolean found = false;
        boolean pageChange = false;
        for (int i = 0; i < numPages && !found; ++i) {
            List components = this.model.getComponentsForPageNumber(i);
            if (!components.contains(comp)) continue;
            if (this.currentPage != i) {
                this.displayPage(i);
                pageChange = true;
            }
            found = true;
        }
        return pageChange;
    }

    public void displayLastPage() {
        if (this.currentPage != this.getPageCount() - 1) {
            this.displayPage(this.getPageCount() - 1);
        }
    }

    public void displayPage(int pageNum) {
        if (pageNum < 0) {
            return;
        }
        this.currentComponents = this.model.getComponentsForPageNumber(pageNum);
        Component[] panelComponents = this.centerPanel.getComponents();
        if (this.currentPage == pageNum && panelComponents.length != 0 && this.currentComponents.size() == panelComponents.length) {
            boolean foundAll = true;
            for (int i = 0; i < panelComponents.length && foundAll; ++i) {
                if (this.currentComponents.contains(panelComponents[i])) continue;
                foundAll = false;
                break;
            }
            if (foundAll) {
                this.updateScrollButtonState();
                return;
            }
        }
        this.centerPanel.removeAll();
        int height = 1;
        int colNumber = 0;
        int x = 0;
        int y = 0;
        if (this.currentComponents.isEmpty()) {
            this.centerPanel.add((Component)this.messagePanel, new Rectangle(this.layoutManager.getGridSize()));
        } else {
            Iterator it = this.currentComponents.iterator();
            while (it.hasNext()) {
                Rectangle area;
                if (this.model.customWidths()) {
                    int[] colWidth = this.model.getColumnWidths();
                    area = new Rectangle(x, y, colWidth[colNumber], height);
                    x += colWidth[colNumber];
                } else {
                    area = new Rectangle(x, y, 1, 1);
                    ++x;
                }
                Component toAdd = (Component)it.next();
                if (this.enabled != null) {
                    toAdd.setEnabled(this.enabled);
                }
                this.centerPanel.add(toAdd, area);
                if (++colNumber != this.model.getColumns()) continue;
                x = 0;
                y += height;
                colNumber = 0;
            }
        }
        this.currentPage = pageNum;
        this.updateScrollButtonState();
        this.centerPanel.validate();
        this.centerPanel.repaint();
        for (PageChangeListener listener : this.pageChangeListeners) {
            listener.pageChanged(new PageChangeEvent(this, pageNum + 1));
        }
    }

    private void updateScrollButtonState() {
        this.nextButton.setEnabled(true);
        this.previousButton.setEnabled(true);
        if (!this.model.hasPageNumber(this.currentPage + 1)) {
            this.nextButton.setEnabled(false);
        }
        if (!this.model.hasPageNumber(this.currentPage - 1)) {
            this.previousButton.setEnabled(false);
        }
        if (this.decoratorAlwaysVisible) {
            this.nextButton.setVisible(true);
            this.previousButton.setVisible(true);
        } else if (!this.model.hasPageNumber(this.currentPage + 1) && !this.model.hasPageNumber(this.currentPage - 1)) {
            this.nextButton.setVisible(false);
            this.previousButton.setVisible(false);
        } else {
            this.nextButton.setVisible(true);
            this.previousButton.setVisible(true);
        }
    }

    @Override
    public void paneChanged(ScrollPaneModelEvent e) {
        if (e.getFirstPage() <= this.currentPage) {
            int displayPage = e.getNumPages() - 1 < this.currentPage ? e.getNumPages() - 1 : this.currentPage;
            this.displayPage(displayPage);
        }
    }

    public void relaxButtonEnabledState() {
        this.enabled = null;
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        super.setEnabled(newEnabled);
        if (this.enabled == null || this.enabled != newEnabled) {
            Boolean bl = this.enabled = newEnabled ? Boolean.TRUE : Boolean.FALSE;
            if (this.model.getPageCount() != 0) {
                this.displayPage(this.currentPage);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.previousButton) {
            this.displayPage(this.currentPage - 1);
        } else if (e.getSource() == this.nextButton) {
            this.displayPage(this.currentPage + 1);
        }
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getPreviousButton() {
        return this.previousButton;
    }

    public void addPageChangeListener(PageChangeListener listener) {
        this.pageChangeListeners.add(listener);
    }

    public void removePageChangeListener(PageChangeListener listener) {
        this.pageChangeListeners.remove(listener);
    }

    public void setEmptyMessage(String theMessage) {
        this.message.setText(theMessage);
    }

    public void setModel(CustomScrollPaneModel newModel) {
        int cols = newModel.getColumns();
        boolean displayPage = false;
        if (this.model != null) {
            cols = this.model.getColumns();
            this.model.removeScrollPaneModelListener(this);
            displayPage = true;
        }
        this.model = newModel;
        this.model.addScrollPaneModelListener(this);
        if (cols != newModel.getColumns()) {
            this.setColumns(newModel.getColumns());
        }
        if (displayPage) {
            this.displayPage(0);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getSource() == this) {
            if (e.getWheelRotation() > 0) {
                if (this.nextButton.isEnabled()) {
                    this.displayPage(this.currentPage + 1);
                }
            } else if (this.previousButton.isEnabled()) {
                this.displayPage(this.currentPage - 1);
            }
        }
    }
}

