/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.UIManager;
import ordermate.gui.button.CustomButton;
import ordermate.gui.button.CustomButtonLabelGenerator;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DataScrollPaneModel
extends AbstractScrollPaneModel
implements CustomScrollPaneModel,
ActionListener {
    public final Signal objectSelected = Signals.createSignal(Displayable.class, "selectedObject");
    private List buttons = new ArrayList();
    private Vector<AbstractButton> selectedButtons = new Vector();
    private List items;
    private ButtonGroup group;
    private CustomButtonLabelGenerator customLabelGenerator = null;

    public DataScrollPaneModel() {
    }

    public DataScrollPaneModel(int columns, int numRowsPerPage) {
        super(columns, numRowsPerPage);
    }

    public DataScrollPaneModel(int[] widths, int numRowsPerPage) {
        super(widths, numRowsPerPage);
    }

    @Override
    public final int getSize() {
        return this.buttons.size();
    }

    @Override
    protected final Component getComponent(int index) {
        return (Component)this.buttons.get(index);
    }

    public void reset() {
        int numPages = this.getPageCount();
        this.buttons.clear();
        this.selectedButtons.removeAllElements();
        this.fireModelEvent(0, numPages, 0);
    }

    public void setItems(List<? extends Displayable> newData) {
        this.items = newData;
        this.setButtons(DataScrollPaneModel.createButtons(newData, this, this.customLabelGenerator));
    }

    public void setItems(List<? extends Displayable> newData, boolean toggle) {
        this.setItems(newData, toggle, true);
    }

    public List getItems() {
        return this.items;
    }

    public void setItems(List<? extends Displayable> newData, boolean toggle, boolean useGroup) {
        if (!toggle) {
            this.setItems(newData);
        } else {
            this.items = newData;
            this.makeGroup(useGroup);
            this.setButtons(DataScrollPaneModel.createToggleButtons(newData, this.group, this, false));
        }
    }

    public void setItems(List<? extends Displayable> newData, boolean toggle, boolean useGroup, boolean selected) {
        if (!toggle) {
            this.setItems(newData);
        } else {
            this.makeGroup(useGroup);
            this.setButtons(DataScrollPaneModel.createToggleButtons(newData, this.group, this, selected));
        }
    }

    private void makeGroup(boolean useGroup) {
        this.group = null;
        if (useGroup) {
            this.group = new ButtonGroup();
        }
    }

    public void setButtons(List buttonList) {
        int numPages = this.getPageCount();
        this.buttons = buttonList;
        this.selectedButtons.removeAllElements();
        this.fireModelEvent(0, numPages, this.getPageCount());
    }

    public static List createButtons(Collection<? extends Displayable> toCreate, ActionListener toListen) {
        return DataScrollPaneModel.createButtons(toCreate, toListen, false, null);
    }

    public static List createButtons(Collection<? extends Displayable> toCreate, ActionListener toListen, CustomButtonLabelGenerator labelGenerator) {
        return DataScrollPaneModel.createButtons(toCreate, toListen, false, labelGenerator);
    }

    public static List<NameDecorator> createButtons(Collection<? extends Displayable> toCreate, ActionListener toListen, boolean preferredSize, CustomButtonLabelGenerator labelGenerator) {
        ArrayList<NameDecorator> toAdd = new ArrayList<NameDecorator>();
        for (Displayable displayable : toCreate) {
            CustomButton<Displayable> button = new CustomButton<Displayable>(displayable, labelGenerator);
            if (preferredSize) {
                button.setPreferredSize(new Dimension(300, 50));
            }
            if (toListen != null) {
                button.addActionListener(toListen);
            }
            toAdd.add(new NameDecorator(button, button.getText()));
            button.setForeground(UIManager.getLookAndFeelDefaults().getColor("Button.foreground"));
        }
        return toAdd;
    }

    public void selectAllButtons(boolean selected) {
        this.selectedButtons.removeAllElements();
        if (this.buttons != null) {
            Iterator it = this.buttons.iterator();
            while (it.hasNext()) {
                AbstractButton nextButton = (AbstractButton)((NameDecorator)it.next()).getDecorateComponent();
                nextButton.setSelected(selected);
                if (!selected) continue;
                this.selectedButtons.add(nextButton);
            }
        }
    }

    public static List<NameDecorator> createToggleButtons(Collection<? extends Displayable> toCreate, ButtonGroup group, ActionListener toListen) {
        return DataScrollPaneModel.createToggleButtons(toCreate, group, toListen, true);
    }

    public static List<NameDecorator> createToggleButtons(Collection<? extends Displayable> toCreate, ButtonGroup group, ActionListener toListen, boolean isSelected) {
        boolean selected = isSelected;
        ArrayList<NameDecorator> toAdd = new ArrayList<NameDecorator>();
        for (Displayable displayable : toCreate) {
            CustomToggleButton<Displayable> button = new CustomToggleButton<Displayable>(displayable);
            if (selected) {
                button.setSelected(true);
                selected = false;
            }
            if (group != null) {
                group.add(button);
            }
            if (toListen != null) {
                button.addActionListener(toListen);
            }
            toAdd.add(new NameDecorator(button, button.getText()));
        }
        return toAdd;
    }

    public void selectButton(Displayable infoToSelect) {
        this.selectedButtons.removeAllElements();
        if (infoToSelect != null) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                Object o = this.buttons.get(i);
                Object info = null;
                AbstractButton button = null;
                if (o instanceof NameDecorator) {
                    o = ((NameDecorator)o).getDecorateComponent();
                }
                if (o instanceof CustomButton) {
                    info = ((CustomButton)o).getData();
                    button = (AbstractButton)o;
                } else if (o instanceof CustomToggleButton) {
                    info = ((CustomToggleButton)o).getData();
                    button = (AbstractButton)o;
                }
                if (info == null || button == null) continue;
                boolean sameInfo = infoToSelect.equals(info);
                button.setSelected(sameInfo);
                if (!sameInfo) continue;
                this.selectedButtons.add(button);
            }
        } else {
            for (int i = 0; i < this.buttons.size(); ++i) {
                Object o = this.buttons.get(i);
                if (o instanceof NameDecorator) {
                    o = ((NameDecorator)o).getDecorateComponent();
                }
                if (!(o instanceof AbstractButton)) continue;
                AbstractButton button = (AbstractButton)o;
                button.setSelected(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof CustomButton) {
            CustomButton customButton = (CustomButton)source;
            Object data = customButton.getData();
            this.objectSelected.emit(data);
        } else if (source instanceof CustomToggleButton) {
            CustomToggleButton toggleButton = (CustomToggleButton)source;
            if (toggleButton.isSelected()) {
                this.selectedButtons.remove(toggleButton);
                this.selectedButtons.add(toggleButton);
            } else {
                this.selectedButtons.remove(toggleButton);
            }
            Object data = toggleButton.getData();
            this.objectSelected.emit(data);
        }
    }

    public List getSelectedButtons() {
        return Collections.unmodifiableList(this.selectedButtons);
    }

    public List<Displayable> getSelections() {
        ArrayList<Displayable> selections = new ArrayList<Displayable>();
        for (AbstractButton button : this.selectedButtons) {
            selections.add((Displayable)((CustomToggleButton)button).getData());
        }
        return selections;
    }

    public List getButtons() {
        return Collections.unmodifiableList(this.buttons);
    }

    public void setSelected(Displayable toSelect) {
        for (Object component : this.buttons) {
            CustomToggleButton button = null;
            button = component instanceof NameDecorator ? (CustomToggleButton)((NameDecorator)component).getDecorateComponent() : (CustomToggleButton)component;
            if (!toSelect.equals(button.getData()) || this.selectedButtons.contains(button)) continue;
            this.selectedButtons.add(button);
            button.setSelected(true);
        }
    }

    public void toggleSelected(Displayable toSelect) {
        for (Object component : this.buttons) {
            CustomToggleButton button = null;
            button = component instanceof NameDecorator ? (CustomToggleButton)((NameDecorator)component).getDecorateComponent() : (CustomToggleButton)component;
            if (!button.getData().equals(toSelect)) continue;
            if (button.isSelected()) {
                this.selectedButtons.add(button);
                continue;
            }
            this.selectedButtons.remove(button);
        }
    }

    public void setCustomLabelGenerator(CustomButtonLabelGenerator customLabelGenerator) {
        this.customLabelGenerator = customLabelGenerator;
    }
}

