/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.gui.scroll.CustomScrollPaneModel;

public class DefaultScrollPaneModel
extends AbstractScrollPaneModel
implements CustomScrollPaneModel {
    private ArrayList<Component> components = new ArrayList();

    public DefaultScrollPaneModel() {
    }

    public DefaultScrollPaneModel(int columns, int numRowsPerPage) {
        super(columns, numRowsPerPage);
    }

    public DefaultScrollPaneModel(int[] widths, int numRowsPerPage) {
        super(widths, numRowsPerPage);
    }

    public void addComponent(Component toAdd) {
        int startPage = this.getPageCount() - 1;
        this.components.add(toAdd);
        int endPage = this.getPageCount() - 1;
        int numPages = this.getPageCount();
        this.fireModelEvent(startPage, endPage, numPages);
    }

    public void setItems(Collection<? extends Component> theComponents) {
        int startPage = 0;
        int endPage = this.getPageCount() - 1;
        if (endPage < 0) {
            endPage = 0;
        }
        this.components = new ArrayList<Component>(theComponents);
        int numPages = this.getPageCount();
        this.fireModelEvent(startPage, endPage, numPages);
    }

    public List getComponents() {
        return this.components;
    }

    @Override
    public int getSize() {
        return this.components.size();
    }

    @Override
    protected Component getComponent(int index) {
        return this.components.get(index);
    }

    protected void removeComponent(int index) {
        this.components.remove(index);
        int startPage = 0;
        int endPage = this.getPageCount() - 1;
        int numPages = this.getPageCount();
        this.fireModelEvent(startPage, endPage, numPages);
    }

    public void removeComponent(Component comp) {
        int i = this.components.indexOf(comp);
        if (i >= 0) {
            this.removeComponent(i);
        }
    }

    public void addComponent(Component comp, int index) {
        if (!this.components.contains(comp)) {
            this.components.add(index, comp);
            int startPage = 0;
            int endPage = this.getPageCount() - 1;
            int numPages = this.getPageCount();
            this.fireModelEvent(startPage, endPage, numPages);
        }
    }

    public void reset() {
        int startPage = 0;
        int endPage = this.getPageCount() - 1;
        int numPages = 1;
        this.components.clear();
        this.fireModelEvent(startPage, endPage, numPages);
    }
}

