/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.ComponentScrollPaneModel;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.jaxb.exporter.handlers.posdatabase.converters.Converters;

public class HtmlReportPanel
extends JPanel {
    private JTextPane textPane;
    private CustomScrollPane scrolly;
    private ComponentScrollPaneModel model;
    private String reportName;

    public HtmlReportPanel(String nameOfReport) {
        super(new BorderLayout());
        this.reportName = nameOfReport;
        this.setOpaque(false);
        this.setupComponents();
    }

    private void setupComponents() {
        this.textPane = new JTextPane();
        this.textPane.setName("txt_report");
        this.textPane.enableInputMethods(false);
        this.textPane.setEditable(false);
        this.textPane.setEditorKit(new HTMLEditorKit());
        this.textPane.setBorder(null);
        ((HTMLEditorKit)this.textPane.getEditorKit()).getStyleSheet().addRule("body {color:" + Converters.getConverterFor(Color.class).convertToString(OrderMateTheme.getDefaultTextColor()) + "}");
        this.model = new ComponentScrollPaneModel(this.textPane);
        this.scrolly = new CustomScrollPane(this.model);
        this.scrolly.setOpaque(false);
        this.scrolly.setDecorationLocation(DecoratorLocation.West);
        this.scrolly.setCenterBorder(new LineBorder(Color.black, 1));
        this.add((Component)this.scrolly, "Center");
        OrderMateTheme.setupTransparentButton(this.scrolly.getNextButton());
        OrderMateTheme.setupTransparentButton(this.scrolly.getPreviousButton());
        this.scrolly.getNextButton().setContentAreaFilled(false);
        this.scrolly.getPreviousButton().setContentAreaFilled(false);
    }

    private String convertColorToHex(Color color) {
        String hexString = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        while (hexString.length() < 6) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public void setListData(List<String> data) {
        StringBuilder SB = new StringBuilder("<html><style>.ItemSeat{margin:0; padding:0;}</style><body style=\"font-family:'arial'\">");
        SB.append("<h2>").append(this.reportName).append("</h2>");
        if (data.isEmpty()) {
            SB.append("<b>There are no " + this.reportName + "</b>");
        } else {
            for (String nextString : data) {
                if (nextString.startsWith("**") && nextString.endsWith("**")) {
                    SB.append("<br><b>").append(nextString.substring(2, nextString.length() - 2)).append("</b>\n");
                } else {
                    SB.append(nextString);
                }
                if (nextString.startsWith("<table")) {
                    SB.append("\n");
                    continue;
                }
                SB.append("<br>\n");
            }
        }
        SB.append("\n</body></html>");
        this.setData(SB.toString());
    }

    public void setData(String data) {
        this.textPane.setText(data);
        this.swapPictures();
        this.textPane.validate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HtmlReportPanel.this.scrolly.displayPage(0);
            }
        });
    }

    public String getData() {
        if (this.textPane != null) {
            return this.textPane.getText();
        }
        return null;
    }

    private void swapPictures() {
        String text;
        String IMG = "*PIC:";
        String IMG_CLOSE = ":PIC*";
        try {
            Document doc = this.textPane.getDocument();
            if (doc.getLength() <= 0) {
                return;
            }
            text = doc.getText(0, doc.getLength() - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
        int index = text.indexOf("*PIC:");
        int lastIndex = text.indexOf(":PIC*", index);
        this.textPane.setEditable(true);
        while (index >= 0 && lastIndex > index) {
            String substring = text.substring(index + "*PIC:".length(), lastIndex);
            this.textPane.select(index, lastIndex + ":PIC*".length());
            this.textPane.insertIcon(IconLoader.get(substring));
            try {
                text = this.textPane.getDocument().getText(0, this.textPane.getDocument().getLength() - 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return;
            }
            index = text.indexOf("*PIC:", lastIndex);
            lastIndex = text.indexOf(":PIC*", index);
        }
        this.textPane.select(0, 0);
        this.textPane.setEditable(false);
    }

    public CustomScrollPane getScrolly() {
        return this.scrolly;
    }
}

