/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import ordermate.OrderMate;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.SingleSelectable;

public class RendererScrollPaneModel<E>
extends AbstractScrollPaneModel {
    private Renderer renderer;
    protected Component[] components;
    protected List<E> objects;
    private ButtonGroup selectionGroup;
    protected Map<Component, Integer> compMap;

    public RendererScrollPaneModel(Renderer theRenderer) {
        this.init(theRenderer);
    }

    public RendererScrollPaneModel(Renderer theRenderer, int cols, int numRowsPerPage) {
        super(cols, numRowsPerPage);
        this.init(theRenderer);
    }

    public RendererScrollPaneModel(Renderer theRenderer, int[] widths, int numRowsPerPage) {
        super(widths, numRowsPerPage);
        this.init(theRenderer);
    }

    private void init(Renderer theRenderer) {
        if (theRenderer == null) {
            String s = "Renderer cannot be null!";
            throw new IllegalArgumentException(s);
        }
        this.renderer = theRenderer;
        this.objects = new ArrayList();
        this.components = new Component[this.getRowsPerPage() * this.getColumns()];
        this.compMap = new HashMap<Component, Integer>();
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    @Override
    public void setColumns(int cols) {
        this.numColumns = cols;
        this.updateComponents();
        super.setColumns(cols);
    }

    @Override
    public void setRowsPerPage(int rows) {
        this.rowsPerPage = rows;
        this.updateComponents();
        super.setRowsPerPage(rows);
    }

    public void emptyComponents() {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = null;
        }
    }

    private void updateComponents() {
        int length = this.getRowsPerPage() * this.getColumns();
        Component[] array = new Component[length];
        if (this.components.length < array.length) {
            length = this.components.length;
        }
        System.arraycopy(this.components, 0, array, 0, length);
        this.components = array;
        this.selectionGroup = null;
        this.compMap.clear();
    }

    protected ButtonGroup getSelectionGroup() {
        if (this.selectionGroup == null) {
            this.selectionGroup = new ButtonObjectGroup();
        }
        return this.selectionGroup;
    }

    public void clearSelection() {
        if (this.components.length > 0 && this.components[0] instanceof SingleSelectable) {
            ButtonModel model = this.getSelectionGroup().getSelection();
            if (model != null) {
                model.setSelected(false);
            }
        } else if (this.components.length > 0 && this.components[0] instanceof AbstractButton) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null) continue;
                ((AbstractButton)this.components[i]).setSelected(false);
            }
        }
    }

    public void addObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to add null object to render scroll pane");
        }
        this.preListChange();
        this.objects.add(object);
        this.postListChange();
    }

    public void addObjects(Collection<? extends E> newObjects) {
        if (newObjects != null) {
            for (E next : newObjects) {
                if (next != null) continue;
                throw new IllegalArgumentException("Attempt to add null object to render scroll pane");
            }
        }
        this.preListChange();
        if (newObjects != null) {
            this.objects.addAll(newObjects);
        }
        this.postListChange();
    }

    public List<E> getObjects() {
        return new ArrayList<E>(this.objects);
    }

    public void setObjects(List<E> objectList) {
        Iterator<E> it = objectList.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            throw new IllegalArgumentException("scroll pane objects should not be null");
        }
        this.preListChange();
        this.objects = new ArrayList<E>(objectList);
        this.postListChange();
    }

    public void setRenderer(Renderer newRenderer) {
        this.init(newRenderer);
        this.refresh();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void removeObject(Object remove) {
        this.preListChange();
        this.objects.remove(remove);
        this.postListChange();
    }

    public void removeAllObjects() {
        this.preListChange();
        this.objects.clear();
        this.postListChange();
    }

    @Override
    public Component getComponent(int i) {
        int index = i;
        if (index < 0 || index >= this.getSize()) {
            String s = index + " is < 0 or >= " + this.getSize();
            throw new ArrayIndexOutOfBoundsException(s);
        }
        int tranIndex = this.transformIndex(index, this.objects.size());
        E obj = this.objects.get(tranIndex);
        int compIndex = index % (this.getRowsPerPage() * this.getColumns());
        if (this.components[compIndex] == null) {
            this.components[compIndex] = this.renderer.createComponent();
            if (this.components[compIndex] instanceof SingleSelectable) {
                SingleSelectable ss = (SingleSelectable)((Object)this.components[index]);
                this.getSelectionGroup().add(ss.getSingleSelectableButton());
                this.compMap.put(ss.getSingleSelectableButton(), index);
            }
        }
        try {
            Component component = this.components[compIndex];
            this.renderer.setupComponent(component, obj, index);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error rendering object in render scroll pane", (Throwable)e);
            this.components[compIndex] = this.renderer.createComponent();
        }
        return this.components[compIndex];
    }

    protected int transformIndex(int compIndex, int max) {
        int objectIndex = compIndex;
        return objectIndex;
    }

    public Component getComponent(Displayable object) {
        if (this.objects.contains(object)) {
            return this.getComponent(this.objects.indexOf(object));
        }
        return null;
    }

    public int getPageNumberFor(Object value) {
        int page = -1;
        if (this.objects.contains(value)) {
            int index = this.objects.indexOf(value);
            int compsPerPage = this.rowsPerPage * this.numColumns;
            page = index / compsPerPage;
        }
        return page;
    }

    class ButtonObjectGroup
    extends ButtonGroup {
        private Object object = null;

        ButtonObjectGroup() {
        }

        @Override
        public boolean isSelected(ButtonModel model) {
            boolean selected = super.isSelected(model);
            if (selected && this.object != null) {
                Integer index = RendererScrollPaneModel.this.compMap.get(this.getButton(model));
                selected &= RendererScrollPaneModel.this.objects.get(index) == this.object;
            }
            return selected;
        }

        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            super.setSelected(model, selected);
            if (selected) {
                Integer index = RendererScrollPaneModel.this.compMap.get(this.getButton(model));
                this.object = RendererScrollPaneModel.this.objects.get(index);
            }
        }

        private AbstractButton getButton(ButtonModel model) {
            AbstractButton button = null;
            Enumeration<AbstractButton> e = this.getElements();
            while (e.hasMoreElements() && button == null) {
                AbstractButton b = e.nextElement();
                if (!b.getModel().equals(model)) continue;
                button = b;
            }
            return button;
        }
    }
}

