/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.UIManager;
import ordermate.gui.scroll.AbstractScrollPaneModel;

public class TextScrollPaneModel
extends AbstractScrollPaneModel {
    private List<String> text = new ArrayList<String>();
    private Font font;

    public TextScrollPaneModel(int numRowsPerPage) {
        super(1, numRowsPerPage);
    }

    public void setLines(List<String> yourLines) {
        this.text.clear();
        this.text.addAll(yourLines);
    }

    public void addLine() {
        this.addLine(null);
    }

    public void addLine(String line) {
        this.preListChange();
        if (line == null || line.length() == 0) {
            this.text.add("");
        } else if (line.indexOf(10) == 0) {
            this.text.add(line);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(line, "\n", true);
            String previousToken = "";
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    if (previousToken.equals("\n")) {
                        this.text.add("");
                    }
                } else {
                    this.text.add(token);
                }
                previousToken = token;
            }
        }
        this.postListChange();
    }

    public void removeLastLine() {
        if (this.text.size() > 0) {
            this.text.remove(this.text.size() - 1);
        }
    }

    public void clear() {
        this.preListChange();
        this.text.clear();
        this.postListChange();
    }

    public void setFont(Font newFont) {
        this.font = newFont;
        this.refresh();
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public int getSize() {
        return this.text.size();
    }

    @Override
    protected Component getComponent(int index) {
        if (index < 0 || index >= this.getSize()) {
            String s = index + " is < 0 or >= " + this.getSize();
            throw new ArrayIndexOutOfBoundsException(s);
        }
        String display = this.text.get(index);
        JLabel component = new JLabel(display);
        if (this.font != null) {
            component.setFont(this.font);
        }
        Color color = UIManager.getColor("Button.foreground");
        component.setForeground(color);
        return component;
    }

    @Override
    public void setColumns(int columns) {
    }
}

