/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.scroll.renderer;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DisplayableToggleRenderer
implements Renderer,
ActionListener {
    public final Signal selected = Signals.createSignal(Displayable.class, "selection");
    public final Signal deselected = Signals.createSignal(Displayable.class, "deselected");
    private List selectedObjects = new ArrayList();
    private ButtonGroup theGroup;

    public DisplayableToggleRenderer() {
        this(false);
    }

    public DisplayableToggleRenderer(boolean asRadioButtons) {
        if (asRadioButtons) {
            this.theGroup = new ButtonGroup();
        }
    }

    public List getSelectedObjects() {
        return new ArrayList(this.selectedObjects);
    }

    public void clearSelection() {
        this.selectedObjects.clear();
        if (this.theGroup != null) {
            this.theGroup.clearSelection();
        }
    }

    public Component createComponent() {
        CustomToggleButton button = new CustomToggleButton();
        button.addActionListener(this);
        if (this.theGroup != null) {
            this.theGroup.add(button);
        }
        return button;
    }

    public void setupComponent(Component component, Object object, int index) {
        Displayable displayable = (Displayable)object;
        CustomToggleButton button = (CustomToggleButton)component;
        button.setSelected(this.selectedObjects.contains(displayable));
        button.setData(displayable);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CustomToggleButton button = (CustomToggleButton)event.getSource();
        if (button.isSelected()) {
            this.selectedObjects.add(button.getData());
            this.selected.emit(button.getData());
        } else {
            this.selectedObjects.remove(button.getData());
            this.deselected.emit(button.getData());
        }
    }
}

