/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.themes;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffTabbedPaneUI;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;

class CustomKunstoffTabbedPaneUI
extends KunststoffTabbedPaneUI {
    private boolean hideSingleTab = true;

    public CustomKunstoffTabbedPaneUI() {
        if (!UIManager.getLookAndFeel().getClass().equals(KunststoffLookAndFeel.class)) {
            throw new IllegalStateException("Cannot use CustomTabbedPaneUI unless the Look and Feel is Kunststoff");
        }
    }

    public CustomKunstoffTabbedPaneUI(boolean hideSingleTb) {
        this();
        this.hideSingleTab = hideSingleTb;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = super.getContentBorderInsets(tabPlacement);
        int normalWidth = insets.top;
        if (tabPlacement == 1) {
            return new Insets(normalWidth, 0, 0, 0);
        }
        if (tabPlacement == 2) {
            return new Insets(0, normalWidth, 0, 0);
        }
        if (tabPlacement == 4) {
            return new Insets(0, 0, 0, normalWidth);
        }
        if (tabPlacement == 3) {
            return new Insets(0, 0, normalWidth, 0);
        }
        throw new IllegalArgumentException("'" + tabPlacement + "' is not a valid tab placement");
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return new Insets(13, 30, 13, 30);
        }
        return new Insets(7, 17, 7, 17);
    }

    public void paint(Graphics g, JComponent c) {
        if (this.tabPane.getTabCount() > 1 || !this.hideSingleTab) {
            super.paint(g, c);
        }
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int theMaxTabHeight) {
        if (this.tabPane.getTabCount() > 1 || !this.hideSingleTab) {
            return super.calculateTabAreaHeight(tabPlacement, horizRunCount, theMaxTabHeight);
        }
        return 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int theMaxTabWidth) {
        if (this.tabPane.getTabCount() > 1 || !this.hideSingleTab) {
            return super.calculateTabAreaWidth(tabPlacement, vertRunCount, theMaxTabWidth);
        }
        return 0;
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 1) {
            super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 2) {
            super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 3) {
            super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 4) {
            super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }
}

