/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.themes;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTabbedPaneUI;

class CustomSubstanceTabbedPaneUI
extends SubstanceTabbedPaneUI {
    private boolean hideSingleTab = true;

    public CustomSubstanceTabbedPaneUI() {
        if (!SubstanceLookAndFeel.class.isAssignableFrom(UIManager.getLookAndFeel().getClass())) {
            throw new IllegalStateException("Cannot use CustomSubstanceTabbedPaneUI unless the Look and Feel is Substance");
        }
    }

    public CustomSubstanceTabbedPaneUI(boolean hideSingleTb) {
        this();
        this.hideSingleTab = hideSingleTb;
    }

    public void paint(Graphics g, JComponent c) {
        if (this.tabPane.getTabCount() > 1 || !this.hideSingleTab) {
            super.paint(g, c);
        }
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int theMaxTabHeight) {
        if (this.tabPane.getTabCount() > 1 || !this.hideSingleTab) {
            return super.calculateTabAreaHeight(tabPlacement, horizRunCount, theMaxTabHeight);
        }
        return 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int theMaxTabWidth) {
        if (this.tabPane.getTabCount() > 1 || !this.hideSingleTab) {
            return super.calculateTabAreaWidth(tabPlacement, vertRunCount, theMaxTabWidth);
        }
        return 0;
    }

    protected JButton createScrollButton(int direction) {
        JButton scrollButton = super.createScrollButton(direction);
        if (direction == 1) {
            scrollButton.setIcon(IconLoader.get("/ordermate/images/uparrow.png"));
        } else if (direction == 5) {
            scrollButton.setIcon(IconLoader.get("/ordermate/images/downarrow.png"));
        } else if (direction == 3) {
            scrollButton.setIcon(IconLoader.get("/ordermate/images/rightarrow.png"));
        } else if (direction == 7) {
            scrollButton.setIcon(IconLoader.get("/ordermate/images/leftarrow.png"));
        }
        return scrollButton;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return new Insets(13, 13, 13, 13);
        }
        return new Insets(7, 17, 7, 17);
    }
}

