/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.themes;

import com.incors.plaf.kunststoff.KunststoffTheme;
import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class KunststoffOrderMateTheme
extends KunststoffTheme {
    private String specialFont;
    private FontUIResource controlFont;
    private FontUIResource systemFont;
    private FontUIResource userFont;
    private FontUIResource smallFont;
    private int scaleFactor;
    private static KunststoffOrderMateTheme instance;

    private KunststoffOrderMateTheme() {
    }

    public static KunststoffOrderMateTheme setupTheme(int scale, String themeFont, Color toggleColor) {
        String fontName = themeFont;
        if (fontName.length() == 0) {
            fontName = null;
        }
        instance = new KunststoffOrderMateTheme();
        KunststoffOrderMateTheme.instance.specialFont = fontName;
        KunststoffOrderMateTheme.instance.scaleFactor = scale;
        if (toggleColor == null) {
            UIManager.put("ToggleButton.select", new Color(0, 255, 0));
        } else {
            UIManager.put("ToggleButton.select", toggleColor);
        }
        UIManager.put("Button.select", new Color(156, 156, 172));
        return instance;
    }

    public KunststoffOrderMateTheme setDefaultColor(Color color) {
        if (color == null) {
            return this;
        }
        UIManager.put("Panel.background", color);
        UIManager.put("Button.background", color);
        UIManager.put("ToggleButton.background", color);
        UIManager.put("RadioButton.background", color);
        UIManager.put("CheckBox.background", color);
        UIManager.put("ColorChooser.background", color);
        UIManager.put("ComboBox.background", color);
        UIManager.put("Label.background", color);
        UIManager.put("List.background", color);
        UIManager.put("MenuBar.background", color);
        UIManager.put("CheckBoxMenuItem.background", color);
        UIManager.put("Menu.background", color);
        UIManager.put("PopupMenu.background", color);
        UIManager.put("OptionPane.background", color);
        UIManager.put("ProgressBar.background", color);
        UIManager.put("ScrollBar.background", color);
        UIManager.put("ScrollPane.background", color);
        UIManager.put("Viewport.background", color);
        UIManager.put("Slider.background", color);
        UIManager.put("SplitPane.background", color);
        UIManager.put("TabbedPane.background", color);
        UIManager.put("TabbedPane.tabBackground", color);
        UIManager.put("TabbedPane.selected", Color.WHITE);
        UIManager.put("Table.background", color);
        UIManager.put("TableHeader.background", color);
        UIManager.put("PasswordField.background", color);
        UIManager.put("TextPane.background", color);
        UIManager.put("EditorPane.background", color);
        UIManager.put("ToolBar.background", color);
        UIManager.put("ToolTip.background", color);
        UIManager.put("Tree.background", color);
        UIManager.put("ToolTip.background", color);
        UIManager.put("ToolTip.background", color);
        UIManager.put("ToolTip.background", color);
        return this;
    }

    public String getSpecialFontName() {
        return this.specialFont;
    }

    private FontUIResource getLargerFont(FontUIResource base) {
        float newSize = base.getSize() + this.scaleFactor;
        return new FontUIResource(base.deriveFont(newSize));
    }

    public FontUIResource getWithSpecialFont(FontUIResource base) {
        if (this.specialFont != null) {
            return new FontUIResource(this.specialFont, base.getStyle(), base.getSize());
        }
        return base;
    }

    public FontUIResource getControlTextFont() {
        if (this.controlFont == null) {
            this.controlFont = this.getLargerFont(this.getWithSpecialFont(super.getControlTextFont()));
        }
        return this.controlFont;
    }

    public FontUIResource getSystemTextFont() {
        if (this.systemFont == null) {
            this.systemFont = this.getLargerFont(this.getWithSpecialFont(super.getSystemTextFont()));
        }
        return this.systemFont;
    }

    public FontUIResource getUserTextFont() {
        if (this.userFont == null) {
            this.userFont = this.getLargerFont(this.getWithSpecialFont(super.getUserTextFont()));
        }
        return this.userFont;
    }

    public FontUIResource getSubTextFont() {
        if (this.smallFont == null) {
            this.smallFont = this.getLargerFont(this.getWithSpecialFont(super.getSubTextFont()));
        }
        return this.smallFont;
    }
}

