/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui.themes;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.reflect.FieldUtils;
import au.com.ordermate.util.image.IconLoader;
import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import ordermate.OrderMate;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.themes.CustomKunstoffTabbedPaneUI;
import ordermate.gui.themes.SubstanceOrderMateTheme;

public class OrderMateTheme
implements OrderMateThemeI {
    public static final String ORDERMATE_TOGGLED = "ordermate.toggled";
    private static final String ORDERMATE_BEFORE_TOGGLED_COLOUR = "ordermate.BeforeToggledColour";
    private static final String ORDERMATE_BEFORE_TOGGLED_BORDER = "ordermate.BeforeToggledBorder";
    public static final String ORDERMATE_VALID_BORDER = "ordermate.validborder";
    public static final String ORDERMATE_SHOWING_INVALID_BORDER = "ordermate.showinginvalidborder";
    public static final String ORDERMATE_BUTTON_SHAPER_PROPERTY = "org.jvnet.substance.button.ClassicButtonShaper";
    public static final String TABPANE_TABINSETS = "TabbedPane.tabInsets";
    public static final String TEXTAREA_BACKGROUND = "TextArea.background";
    public static final String TEXTAREA_FOREGROUND = "TextArea.foreground";
    private static final String LABEL_FONT = "Label.font";
    public static final String TOGGLEBUTTON_SELECT = "ToggleButton.select";
    public static final String BUTTON_SELECT = "Button.select";
    private static Font VERY_LARGE;
    private static Font LARGE;
    private static Font MEDIUM;
    private static Font SMALL;
    private static Font SMALLER;
    private static ToggleMode toggleMode;
    public static final Color ORDERMATE_RED;

    public static void initFonts() {
        Font controlFont = UIManager.getFont(LABEL_FONT);
        float baseSize = controlFont.getSize();
        VERY_LARGE = controlFont.deriveFont(baseSize * 3.0f);
        LARGE = controlFont.deriveFont((float)((double)baseSize * 1.5));
        MEDIUM = controlFont.deriveFont((float)((double)baseSize * 1.25));
        SMALL = controlFont;
        SMALLER = controlFont.deriveFont((float)((double)baseSize * 0.9));
    }

    public static void setupTabbedPane(JTabbedPane toSetup) {
        OrderMateTheme.setupTabbedPane(toSetup, true);
    }

    private static boolean isSubstance() {
        return UIManager.getLookAndFeel().getName().indexOf("Substance") != -1;
    }

    public static void setTabColour(JTabbedPane pane, int index, Color colour) {
        pane.setBackgroundAt(index, colour);
        if (OrderMateTheme.isSubstance()) {
            SubstanceOrderMateTheme.setTabColour(pane, index, colour);
        }
    }

    @Override
    public void setupKeypadButton(AbstractButton toSetup) {
        if (OrderMateTheme.isSubstance()) {
            SubstanceOrderMateTheme.setupKeypadButton(toSetup);
        }
    }

    public static void setupTabbedPane(JTabbedPane toSetup, boolean hideSingleTab) {
        if (UIManager.getLookAndFeel().getClass().equals(KunststoffLookAndFeel.class)) {
            toSetup.setUI((TabbedPaneUI)((Object)new CustomKunstoffTabbedPaneUI(hideSingleTab)));
        } else if (OrderMateTheme.isSubstance()) {
            SubstanceOrderMateTheme.setupTabedPane(toSetup, hideSingleTab);
        } else if (BasicTabbedPaneUI.class.isAssignableFrom(toSetup.getUI().getClass())) {
            Insets oldInsets = UIManager.getInsets(TABPANE_TABINSETS);
            UIManager.put(TABPANE_TABINSETS, new Insets(7, 17, 7, 17));
            toSetup.getUI().installUI(toSetup);
            UIManager.put(TABPANE_TABINSETS, oldInsets);
        }
    }

    public static void setupTransparentButton(AbstractButton toSetup) {
        toSetup.setBorderPainted(false);
        if (!(toSetup instanceof JToggleButton)) {
            toSetup.setContentAreaFilled(true);
        }
        toSetup.setRolloverEnabled(false);
        if (OrderMateTheme.isSubstance()) {
            SubstanceOrderMateTheme.setupTransparentButton(toSetup);
        }
    }

    public static void setupTouchScreenButton(final AbstractButton toSetup) {
        toSetup.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
                toSetup.doClick();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }
        });
    }

    public static void setupNavBarButton(AbstractButton toSetup) {
        OrderMateTheme.setupTouchScreenButton(toSetup);
        toSetup.setHorizontalTextPosition(0);
        toSetup.setVerticalTextPosition(3);
        toSetup.setForeground(UIManager.getColor(TEXTAREA_FOREGROUND));
        OrderMateTheme.setupTransparentButton(toSetup);
        toSetup.setBorderPainted(true);
    }

    @Override
    public void setButtonColour(AbstractButton button, Color foreground, Color background) {
        if (button.getClientProperty(ORDERMATE_TOGGLED) != null) {
            return;
        }
        button.setForeground(foreground);
        button.setBackground(background);
    }

    public static void setupToggledButton(AbstractButton toggled) {
        OrderMateTheme.initToggleMode();
        if (toggled.getClientProperty(ORDERMATE_TOGGLED) == null) {
            toggled.putClientProperty(ORDERMATE_TOGGLED, Boolean.TRUE);
            toggleMode.toggle(toggled);
        }
    }

    public static void setupUntoggledButton(AbstractButton notToggled) {
        OrderMateTheme.initToggleMode();
        if (notToggled.getClientProperty(ORDERMATE_TOGGLED) != null) {
            toggleMode.untoggle(notToggled);
            notToggled.putClientProperty(ORDERMATE_TOGGLED, null);
        }
    }

    public static void setupScrollPane(JScrollPane toSetup) {
        OrderMateTheme.checkSetup();
        JScrollBar vScroll = toSetup.getVerticalScrollBar();
        JScrollBar hScroll = toSetup.getHorizontalScrollBar();
        if (vScroll.getUI() instanceof BasicScrollBarUI && hScroll.getUI() instanceof BasicScrollBarUI) {
            try {
                OrderMateTheme.setupScrollBar(vScroll);
                OrderMateTheme.setupScrollBar(hScroll);
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Error trying to setup scroll bar buttons", (Throwable)e);
                vScroll.setPreferredSize(new Dimension(30, 30));
                hScroll.setPreferredSize(new Dimension(30, 30));
            }
        } else {
            vScroll.setPreferredSize(new Dimension(30, 30));
            hScroll.setPreferredSize(new Dimension(30, 30));
        }
    }

    public static void setupScrollBar(JScrollBar scroll) throws Exception {
        ScrollBarUI scrollUI = scroll.getUI();
        if (OrderMateTheme.isSubstance()) {
            SubstanceOrderMateTheme.setupScrollBar(scroll);
        } else if (scrollUI instanceof BasicScrollBarUI) {
            JButton decrButton = (JButton)FieldUtils.getField(BasicScrollBarUI.class, "decrButton").get(scrollUI);
            JButton incrButton = (JButton)FieldUtils.getField(BasicScrollBarUI.class, "incrButton").get(scrollUI);
            if (scroll.getOrientation() == 1) {
                ImageIcon icon = IconLoader.get("/ordermate/images/uparrow.png");
                Dimension iconDimensions = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                decrButton.setIcon(icon);
                decrButton.setPreferredSize(iconDimensions);
                icon = IconLoader.get("/ordermate/images/downarrow.png");
                iconDimensions = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                incrButton.setIcon(icon);
                incrButton.setPreferredSize(iconDimensions);
                scroll.setPreferredSize(new Dimension(iconDimensions.width, scroll.getPreferredSize().height));
            } else {
                ImageIcon icon = IconLoader.get("/ordermate/images/leftarrow.png");
                Dimension iconDimensions = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                decrButton.setIcon(icon);
                decrButton.setPreferredSize(iconDimensions);
                icon = IconLoader.get("/ordermate/images/rightarrow.png");
                iconDimensions = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                incrButton.setIcon(icon);
                incrButton.setPreferredSize(iconDimensions);
                scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, iconDimensions.height));
            }
        }
    }

    private static void checkSetup() {
        if (LARGE == null || MEDIUM == null || SMALL == null) {
            OrderMateTheme.initFonts();
        }
    }

    public static Font getVeryLargeFont() {
        OrderMateTheme.checkSetup();
        return VERY_LARGE;
    }

    public static Font getLargeFont() {
        OrderMateTheme.checkSetup();
        return LARGE;
    }

    public static Font getMediumFont() {
        OrderMateTheme.checkSetup();
        return MEDIUM;
    }

    public static Font getSmallFont() {
        OrderMateTheme.checkSetup();
        return SMALL;
    }

    public static Font getSmallerFont() {
        OrderMateTheme.checkSetup();
        return SMALLER;
    }

    public static final Color getDefaultTextColor() {
        return UIManager.getColor("Button.foreground");
    }

    public static final Color getDefaultBackgroundColor() {
        return UIManager.getColor("Panel.background");
    }

    public static final TitledBorder makeTitledBorder(String title) {
        TitledBorder border = BorderFactory.createTitledBorder(title);
        border.setTitleColor(OrderMateTheme.getDefaultTextColor());
        return border;
    }

    private static void initToggleMode() {
        if (toggleMode == null) {
            Color configColor = null;
            if (!Config.getStringValue("toggle_color").isEmpty()) {
                try {
                    configColor = Color.decode(Config.getStringValue("toggle_color"));
                }
                catch (NumberFormatException nfe) {
                    OrderMate.LOG.warn("Invalid toggle color in the INI file", (Throwable)nfe);
                }
            }
            if (configColor == null && (configColor = UIManager.getColor(TOGGLEBUTTON_SELECT)) == null) {
                configColor = Color.GREEN;
            }
            final Color color = configColor;
            toggleMode = Config.getStringValue("toggle").equals("border") ? new ToggleMode(){

                @Override
                public void toggle(AbstractButton toggled) {
                    toggled.putClientProperty(OrderMateTheme.ORDERMATE_BEFORE_TOGGLED_BORDER, toggled.getBorder());
                    toggled.setBorder(BorderFactory.createLineBorder(color, 3));
                }

                @Override
                public void untoggle(AbstractButton notToggled) {
                    Border oldBorder = (Border)notToggled.getClientProperty(OrderMateTheme.ORDERMATE_BEFORE_TOGGLED_BORDER);
                    notToggled.setBorder(oldBorder);
                    notToggled.putClientProperty(OrderMateTheme.ORDERMATE_BEFORE_TOGGLED_BORDER, null);
                }
            } : (Config.getStringValue("toggle").equals("no") ? new ToggleMode(){

                @Override
                public void toggle(AbstractButton toggled) {
                }

                @Override
                public void untoggle(AbstractButton notToggled) {
                }
            } : new ToggleMode(){

                @Override
                public void toggle(AbstractButton toggled) {
                    toggled.putClientProperty(OrderMateTheme.ORDERMATE_BEFORE_TOGGLED_COLOUR, toggled.getBackground());
                    toggled.setBackground(color);
                }

                @Override
                public void untoggle(AbstractButton notToggled) {
                    Color oldBackground = (Color)notToggled.getClientProperty(OrderMateTheme.ORDERMATE_BEFORE_TOGGLED_COLOUR);
                    notToggled.setBackground(oldBackground);
                    notToggled.putClientProperty(OrderMateTheme.ORDERMATE_BEFORE_TOGGLED_COLOUR, null);
                }
            });
        }
    }

    static {
        toggleMode = null;
        ORDERMATE_RED = new Color(229, 57, 53);
    }

    private static interface ToggleMode {
        public void toggle(AbstractButton var1);

        public void untoggle(AbstractButton var1);
    }
}

