/*
 * Decompiled with CFR 0.152.
 */
package ordermate.guicore;

import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import ordermate.OrderMate;
import ordermate.guicore.StyleRule;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractBeanRule
implements StyleRule,
Serializable {
    private String name;

    public AbstractBeanRule(String yourName) {
        this.name = yourName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract boolean matches(Component var1);

    @Override
    public void style(Component toStyle) {
        try {
            Object objValue;
            Class propertyClass = PropertyUtils.getPropertyType((Object)toStyle, (String)this.getProperty());
            try {
                objValue = this.getStatic(this.getValue());
            }
            catch (Exception e) {
                objValue = ConvertUtils.convert((String)this.getValue(), (Class)propertyClass);
            }
            PropertyUtils.setProperty((Object)toStyle, (String)this.getProperty(), (Object)objValue);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error setting property " + this.getProperty() + ":\n", (Throwable)e);
        }
    }

    private Object getStatic(String staticField) throws NoSuchFieldException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        int breakPoint = this.getValue().lastIndexOf(46);
        if (breakPoint == -1) {
            throw new IllegalArgumentException(staticField + " is not a static field (Could not find any '.')");
        }
        String className = staticField.substring(0, breakPoint);
        String fieldName = staticField.substring(breakPoint + 1);
        Class<?> clazz = Class.forName(className);
        Field field = clazz.getField(fieldName);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new NoSuchFieldException(clazz + " contains field " + fieldName + " however it is not static");
        }
        Object retValue = field.get(null);
        return retValue;
    }

    protected abstract String getProperty();

    protected abstract String getValue();

    public String toString() {
        return "StyleRule(" + this.name + " : " + this.getProperty() + ": " + this.getValue() + ")";
    }
}

