/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue;

import javax.jms.JMSException;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.commandqueue.MessageActionFactory;
import ordermate.hom.commandqueue.MessageDispatcher;
import ordermate.hom.commandqueue.MessageReceiver;
import ordermate.hom.commandqueue.actionImpl.InvalidMessageActionImpl;
import ordermate.hom.jms.JMSConsumerService;

public class HOCommandQueue
implements Runnable {
    private static final String SUBJECT = "COMMAND";
    private static final int RETRY = 600000;
    private JMSConsumerService jmsService;
    private final MessageDispatcher dispatcher = new MessageDispatcher();
    private final MessageReceiver messageListener = new MessageReceiver(this.dispatcher);

    public void registerActionFactory(MessageActionFactory actionFactory) {
        OrderMate.LOG.info("Adding command action factory:" + actionFactory.getCommandName());
        this.dispatcher.addMessageAction(actionFactory.getCommandName(), actionFactory);
    }

    @Override
    public void run() {
        this.messageListener.setInvalidMessageAction(new InvalidMessageActionImpl());
        try {
            while (true) {
                if (this.jmsService != null) {
                    this.jmsService.closeConnection();
                    this.jmsService = null;
                }
                if (this.jmsService == null) {
                    Long storeID = this.getStoreId();
                    this.jmsService = new JMSConsumerService("COMMAND-" + storeID);
                    this.jmsService.createConnection();
                    if (!this.jmsService.isConnectionValid()) {
                        OrderMate.LOG.warn("Command Queue JMSService is invalid, cannot connect. Will retry in 10 minutes");
                        this.jmsService = null;
                        OrderMate.LOG.info("Interrupted while waiting to reconnect.");
                    }
                    if (this.jmsService != null) {
                        try {
                            this.jmsService.createConsumer();
                            this.jmsService.setMessageListener(this.messageListener);
                        }
                        catch (JMSException jmsEx) {
                            OrderMate.LOG.warn("JMS Exception in command queue, will sleep for 10 mins, and retry");
                            this.jmsService.closeConnection();
                            this.jmsService = null;
                        }
                    }
                }
                Thread.sleep(600000L);
            }
        }
        catch (InterruptedException ie) {
            OrderMate.LOG.info("Command queue thread interrupted while awaiting retry, command queue exiting", (Throwable)ie);
            return;
        }
    }

    protected Long getStoreId() {
        return StoreGroup.getInstance().getStoreId();
    }
}

