/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.jms.Message;
import javax.jms.TextMessage;
import ordermate.OrderMate;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageAction;
import ordermate.hom.commandqueue.MessageActionFactory;

public class MessageDispatcher {
    private final HashMap<String, MessageActionFactory> messageActions = new HashMap();
    private final ExecutorService executorService;

    public MessageDispatcher(ExecutorService execService) {
        this.executorService = execService;
    }

    public MessageDispatcher() {
        this(Executors.newSingleThreadExecutor());
    }

    public void addMessageAction(String msgID, MessageActionFactory action) {
        this.messageActions.put(msgID, action);
    }

    public Future dispatch(String msgID, Message param) {
        return this.dispatch(msgID, param, null, null);
    }

    public Future dispatch(String msgID, Message message, MessageAction replyAction, InvalidMessageAction invalidMessageAction) {
        MessageActionFactory factory = this.messageActions.get(msgID);
        if (!(message instanceof TextMessage)) {
            if (invalidMessageAction != null) {
                invalidMessageAction.notifyError(message);
            }
            OrderMate.LOG.error("Command message was not a text message");
            return null;
        }
        if (factory != null) {
            try {
                MessageAction action = factory.createMessageAction(replyAction, invalidMessageAction);
                action.setParameter(message);
                return this.executorService.submit(action);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error occurred processing command message : " + message + " will attempt to notify business central of error", (Throwable)ex);
                if (invalidMessageAction != null) {
                    invalidMessageAction.notifyError(message);
                }
                return null;
            }
        }
        OrderMate.LOG.warn("Unknown action : " + msgID + " could not perform action");
        if (invalidMessageAction != null) {
            invalidMessageAction.notifyError(message);
        }
        return null;
    }
}

