/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import ordermate.OrderMate;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageDispatcher;

public class MessageReceiver
implements MessageListener {
    private final MessageDispatcher dispatcher;
    private InvalidMessageAction invalidMsgAction;

    public MessageReceiver(MessageDispatcher msgDispatcher) {
        this.dispatcher = msgDispatcher;
    }

    protected void setInvalidMessageAction(InvalidMessageAction action) {
        this.invalidMsgAction = action;
    }

    public void onMessage(Message jmsMsg) {
        if (this.invalidMsgAction == null) {
            throw new IllegalStateException("Message receiver is not configured with an invalid message action");
        }
        if (jmsMsg == null) {
            return;
        }
        try {
            String msgID = jmsMsg.getJMSType();
            OrderMate.LOG.info("Message received on command queue : " + msgID + "\n" + jmsMsg);
            this.dispatcher.dispatch(msgID, jmsMsg, null, this.invalidMsgAction);
        }
        catch (JMSException ex) {
            OrderMate.LOG.error("JMS error caught in message receiver, attempting to notify producer", (Throwable)ex);
            this.invalidMsgAction.notifyError(jmsMsg);
        }
    }

    InvalidMessageAction getInvalidMessageAction() {
        return this.invalidMsgAction;
    }
}

