/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.actionImpl;

import javax.jms.JMSException;
import javax.jms.Message;
import ordermate.OrderMate;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.jms.JMSProducerService;

public class InvalidMessageActionImpl
implements InvalidMessageAction {
    private static final int RETRY = 60000;
    private static final String INVALID_SUBJECT = "INVALID";
    private JMSProducerService invalidMessageProducer = new JMSProducerService("INVALID");

    public InvalidMessageActionImpl() {
        this.invalidMessageProducer.createConnection();
    }

    @Override
    public void notifyError(Message jmsMsg) {
        if (this.invalidMessageProducer.isConnectionValid()) {
            try {
                if (!this.invalidMessageProducer.isValidProducer()) {
                    this.invalidMessageProducer.createProducer();
                }
                if (!this.invalidMessageProducer.isValidProducer()) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                    this.notifyError(jmsMsg);
                    return;
                }
                this.invalidMessageProducer.getMessageProducer().send(jmsMsg);
                return;
            }
            catch (JMSException ex) {
                OrderMate.LOG.error("Could not notify business central of invalid message", (Throwable)ex);
            }
        } else {
            OrderMate.LOG.warn("Could not notify business central of invalid message, could not create connection");
        }
    }
}

