/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.menu;

import au.com.ordermate.persistence.PersistenceManager;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Message;
import ordermate.OrderMate;
import ordermate.database.schedule.Schedule;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageAction;
import ordermate.hom.commandqueue.actionImpl.AbstractMessageAction;
import ordermate.hom.commandqueue.webresource.HOWebNotifier;
import ordermate.scheduler.Recurrence;
import org.apache.logging.log4j.Level;

public class MenuDownloadAction
extends AbstractMessageAction<Schedule>
implements Serializable {
    public static final String PROPERTY_DOWNLOAD_MENU_MENU_NAME = "menuName";
    public static final String PROPERTY_DOWNLOAD_MENU_MENU_ID = "menuId";
    public static final String PROPERTY_DOWNLOAD_MENU_EXPORT_MODE = "exportMode";
    public static final String PROPERTY_DOWNLOAD_MENU_SCHEDULE = "cronSchedule";
    public static final String PROPERTY_DOWNLOAD_MENU_DOWNLOAD_LOCATION = "menuDownloadLocation";
    private Map<String, Object> properties = new HashMap<String, Object>();

    @Deprecated
    protected MenuDownloadAction() {
        this(null, null);
    }

    protected MenuDownloadAction(MessageAction reply, InvalidMessageAction invalidMessage) {
        super(reply, invalidMessage);
    }

    @Override
    public void setParameter(Message param) throws Exception {
        this.properties.put(PROPERTY_DOWNLOAD_MENU_MENU_ID, param.getLongProperty(PROPERTY_DOWNLOAD_MENU_MENU_ID));
        this.properties.put(PROPERTY_DOWNLOAD_MENU_MENU_NAME, param.getStringProperty(PROPERTY_DOWNLOAD_MENU_MENU_NAME));
        this.properties.put(PROPERTY_DOWNLOAD_MENU_DOWNLOAD_LOCATION, param.getStringProperty(PROPERTY_DOWNLOAD_MENU_DOWNLOAD_LOCATION));
        this.properties.put(PROPERTY_DOWNLOAD_MENU_SCHEDULE, param.getStringProperty(PROPERTY_DOWNLOAD_MENU_SCHEDULE));
        this.properties.put(PROPERTY_DOWNLOAD_MENU_EXPORT_MODE, param.getStringProperty(PROPERTY_DOWNLOAD_MENU_EXPORT_MODE));
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Schedule call() throws Exception {
        String deleteThem = "SELECT * FROM config_scheduled_task WHERE task = 'Menu Download Task'";
        for (Schedule schedule : PersistenceManager.getObjectList(Schedule.class, deleteThem)) {
            schedule.delete();
        }
        Schedule schedule = new Schedule();
        schedule.setLabel("Menu download : " + this.getProperty(PROPERTY_DOWNLOAD_MENU_MENU_NAME));
        schedule.setRecurrence("" + this.getProperty(PROPERTY_DOWNLOAD_MENU_SCHEDULE));
        schedule.setTask("Menu Download Task");
        schedule.setData(this);
        schedule.save();
        Recurrence recurrence = null;
        try {
            recurrence = schedule.toRecurrence();
        }
        catch (ParseException ex) {
            OrderMate.LOG.log(Level.WARN, "The schedule " + schedule + " does not contain a valid recurrence.", (Throwable)ex);
        }
        if (recurrence != null) {
            HOWebNotifier.getInstance().notifyHeadOffice("Menu", "Received Schedule at " + schedule.getRecurrence() + ": Run at " + recurrence.getNextValidTimeAfter(new Date()), null);
        } else {
            HOWebNotifier.getInstance().notifyHeadOffice("Menu", "Received Schedule at " + schedule.getRecurrence() + ": Will NOT run", null);
        }
        return schedule;
    }
}

