/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.menu;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.WebResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.User;
import ordermate.hom.commandqueue.menu.MenuDownloadAction;
import ordermate.hom.commandqueue.webresource.HOWebNotifier;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.integration.nudgeback.EmailBuilder;
import ordermate.integration.webservice.RestHelper;
import ordermate.jaxb.exporter.handlers.posdatabase.PosXMLIntegrator;
import ordermate.scheduler.Task;
import org.apache.activemq.util.ByteArrayInputStream;

public class MenuDownloadTask
implements Task {
    private static final String MAIL_IMPORT = "Mail Import Results";
    private static final String DEFAULT_MAILOUT = "corp-relations@ordermate.com.au";
    private static final Integer CONNECT_TIMEOUT = 60000;
    private static final Integer TIMEOUT = 600000;
    public static final String NAME = "Menu Download Task";
    private MenuDownloadAction action;
    private PosXMLIntegrator posIntegrator = null;
    private RestHelper restHelper = null;

    public MenuDownloadTask() {
    }

    protected MenuDownloadTask(RestHelper helper, PosXMLIntegrator integrator) {
        this.restHelper = helper;
        this.posIntegrator = integrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String menuUrl = null;
        Exception exception = null;
        try {
            this.initObjects();
            OrderMate.LOG.info("Starting menu download task");
            menuUrl = "" + this.action.getProperty("menuDownloadLocation");
            menuUrl = menuUrl + "/" + this.action.getProperty("menuId");
            menuUrl = menuUrl + "/" + this.action.getProperty("exportMode");
            OrderMate.LOG.info("Downloading menu from :" + menuUrl);
            HOWebNotifier.getInstance().notifyHeadOffice("Menu", "Downloading menu...", menuUrl);
            String xmlText = this.downloadXML(menuUrl);
            File file = new File("C:\\temp\\downloadedMenu.xml");
            if (!file.exists()) {
                file.createNewFile();
            }
            StringUtils.writeTextToFile(file, xmlText);
            OrderMate.LOG.info("Downloaded XML Menu, starting menu import");
            HOWebNotifier.getInstance().notifyHeadOffice("Menu", "Downloaded menu: " + file.length() / 1024L + "kB", null);
            this.posIntegrator.importDB(new BufferedInputStream((InputStream)new ByteArrayInputStream(xmlText.getBytes("UTF-8"))));
            OrderMate.LOG.info("Completed menu download task");
        }
        catch (Exception ex) {
            try {
                exception = ex;
                OrderMate.LOG.error("Could not import menu from " + menuUrl, (Throwable)ex);
            }
            catch (Throwable throwable) {
                HOWebNotifier.getInstance().notifyHeadOffice("Menu", exception != null ? "Unsuccessful" : "Successfully Imported Menu", this.getResultsString(this.posIntegrator, exception));
                this.doEmail(this.posIntegrator, exception);
                this.clearObjects();
                throw throwable;
            }
            HOWebNotifier.getInstance().notifyHeadOffice("Menu", exception != null ? "Unsuccessful" : "Successfully Imported Menu", this.getResultsString(this.posIntegrator, exception));
            this.doEmail(this.posIntegrator, exception);
            this.clearObjects();
        }
        HOWebNotifier.getInstance().notifyHeadOffice("Menu", exception != null ? "Unsuccessful" : "Successfully Imported Menu", this.getResultsString(this.posIntegrator, exception));
        this.doEmail(this.posIntegrator, exception);
        this.clearObjects();
    }

    private void initObjects() {
        if (this.restHelper == null) {
            this.restHelper = new RestHelper();
        }
        if (this.posIntegrator == null) {
            this.posIntegrator = new PosXMLIntegrator(new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()), PersistenceManager.getPersistenceDelegate());
        }
    }

    private void clearObjects() {
        this.restHelper = null;
        this.posIntegrator.clearAfterImport();
        this.posIntegrator = null;
        System.gc();
    }

    private void doEmail(PosXMLIntegrator integrator, Exception exception) {
        try {
            String mailTo = DEFAULT_MAILOUT;
            ExperimentalFeature mailItOut = ExperimentalFeature.find(MAIL_IMPORT);
            if (mailItOut != null) {
                mailTo = mailItOut.getStringValue(mailTo);
            }
            if (!StringUtils.isEmpty(mailTo)) {
                BusinessInfo info = BusinessInfo.getInstance();
                String result = this.getResultsString(integrator, exception);
                EmailBuilder email = new EmailBuilder("Menu Import for " + info.getName() + ": " + info.getAddressString(), result, true, mailTo);
                new NudgeUtil().sendEmail(email.build());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't mail out the results, sorry", (Throwable)ex);
        }
    }

    private String getResultsString(PosXMLIntegrator integrator, Exception exception) {
        StringBuilder SB = new StringBuilder("Import at ");
        SB.append(new Date()).append(" has been performed. It was ");
        SB.append(exception != null ? "unsuccessful" : "successful").append("\r\n\r\n");
        SB.append("Here are the results:\r\n\r\n").append(this.posIntegrator.getChangeLogger().getAsCsv());
        if (exception != null) {
            SB.append("\r\n\r\n");
            SB.append("The Exception was " + exception.getMessage()).append("\r\n");
            SB.append(Arrays.toString(exception.getStackTrace()));
        }
        return SB.toString();
    }

    private int getWebserviceConnTimeout() {
        SystemProperty property = SystemProperty.getInstance();
        int connTimeout = property.getWebserviceConnTimeout();
        if (connTimeout <= 0) {
            return CONNECT_TIMEOUT;
        }
        return connTimeout;
    }

    private int getWebserviceReadTimeout() {
        SystemProperty property = SystemProperty.getInstance();
        int readTimeout = property.getWebserviceReadTimeout();
        if (readTimeout <= 0) {
            return TIMEOUT;
        }
        return readTimeout;
    }

    protected String downloadXML(String menuURL) {
        int connTimeout = this.getWebserviceConnTimeout();
        int readTimeout = this.getWebserviceReadTimeout();
        WebResource resource = this.restHelper.getResource(menuURL, connTimeout, readTimeout);
        resource = this.restHelper.addBasicAuth(resource, StoreGroup.getInstance().getStoreId().toString(), StoreGroup.getInstance().getStoreName());
        return this.restHelper.getText(resource);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
        if (data == null) {
            throw new IllegalArgumentException("Data for menu download task should not be null");
        }
        if (!(data instanceof MenuDownloadAction)) {
            throw new IllegalArgumentException("Data for menu download task should be a MenuDownloadAction but was" + data.getClass());
        }
        this.action = (MenuDownloadAction)data;
    }
}

