/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.permissions;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import ordermate.OrderMate;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.PermissionLoader;
import ordermate.hom.commandqueue.permissions.PermissionsImportAction;
import ordermate.integration.jaxb.permissions.PermissionExt;
import ordermate.integration.jaxb.permissions.PermissionGroupExt;
import ordermate.integration.jaxb.permissions.PermissionGroupListExt;
import ordermate.scheduler.Task;

public class PermissionsImportTask
implements Task {
    public static final String NAME = "Permission Import Task";
    private PermissionsImportAction action;

    @Override
    public void run() {
        try {
            this.importPermissions((String)this.action.getProperty("permissionsData"));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Could not import Permissions", (Throwable)ex);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
        if (data == null) {
            throw new IllegalArgumentException("Data for Import Permissions Task should not be null");
        }
        if (!(data instanceof PermissionsImportAction)) {
            throw new IllegalArgumentException("Data for Import Permissions Task should be a PermissionDownloadAction but was" + data.getClass());
        }
        this.action = (PermissionsImportAction)data;
    }

    private void importPermissions(String permissionsXML) {
        try {
            PermissionGroupListExt permissionGroupList = this.unMarshallPermissionsGroupList(permissionsXML);
            for (PermissionGroupExt group : permissionGroupList.getPermissionGroupsExt()) {
                PermissionGroup permGroup = PermissionGroup.getPermissionGroupForName(group.getName());
                if (permGroup == null) continue;
                for (PermissionExt perm : group.getPermissions().getPermissions()) {
                    Permission permissionToUpdate = PermissionLoader.getInstance().load(perm.getName());
                    if (permissionToUpdate != null) {
                        permGroup.setAccessLevel(permissionToUpdate, perm.getAccess().toString());
                        continue;
                    }
                    OrderMate.LOG.error("Permission Import - Permission not found: " + perm.getName());
                }
                permGroup.save();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while importing Permissions", (Throwable)ex);
        }
    }

    private PermissionGroupListExt unMarshallPermissionsGroupList(String permissionsXML) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)PermissionGroupListExt.class.getPackage().getName());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        PermissionGroupListExt permissionGroupList = (PermissionGroupListExt)unmarshaller.unmarshal((Reader)new StringReader(permissionsXML));
        return permissionGroupList;
    }
}

