/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.reportrequest;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.hom.commandqueue.reportrequest.ReportRequestResponder;

public abstract class AbstractTradingDayReportResponder<T extends PersistentObject>
extends ReportRequestResponder<T> {
    public AbstractTradingDayReportResponder(PropertiedObject.Property ... verifyingProperties) {
        super(verifyingProperties);
    }

    @Override
    protected Collection<T> findReports(Date from, Date to) {
        if (from == null) {
            from = new Date(1000L);
        }
        if (to == null) {
            to = from;
        }
        return this.doFindReports(from, to);
    }

    protected abstract Collection<T> doFindReports(Date var1, Date var2);

    @Override
    protected Date getNextValidDate(Date from, Date to) {
        List<TradingDay> days = this.getValidAndNext(to);
        Date next = days.get(days.size() - 1).getDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(next);
        if (from != null && from.equals(next)) {
            cal.add(5, 1);
            next = cal.getTime();
        }
        return next;
    }

    protected List<TradingDay> getValidAndNext(Date date) {
        Date theDate = date;
        if (theDate == null) {
            theDate = new Date(1000L);
        }
        return PersistenceManager.getObjectList(TradingDay.class, Query.select(TradingDay.class).greaterThanOrEqual(TradingDay.Properties.DATE, theDate, SQLDateType.TIMESTAMP).orderBy(TradingDay.Properties.DATE, false).limit(2).toString(), null);
    }
}

