/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.reportrequest;

import java.util.Date;
import javax.jms.Message;
import ordermate.OrderMate;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageAction;
import ordermate.hom.commandqueue.actionImpl.AbstractMessageAction;
import ordermate.hom.commandqueue.reportrequest.ReportRequestResponder;
import ordermate.hom.commandqueue.reportrequest.ReportResponseFactory;

public class HORequestReportAction
extends AbstractMessageAction {
    public static final String PROPERTY_REQUEST_REPORT_CLASS = "clazz";
    public static final String PROPERTY_REQUEST_REPORT_FROM_DATE = "fromDate";
    public static final String PROPERTY_REQUEST_REPORT_TO_DATE = "toDate";
    private String clazzPath;
    private Date fromDate;
    private Date toDate;

    HORequestReportAction(MessageAction successAction, InvalidMessageAction invalidAction) {
        super(successAction, invalidAction);
    }

    @Override
    public void setParameter(Message param) throws Exception {
        this.clazzPath = param.getStringProperty(PROPERTY_REQUEST_REPORT_CLASS);
        long fromTime = param.getLongProperty(PROPERTY_REQUEST_REPORT_FROM_DATE);
        long toTime = param.getLongProperty(PROPERTY_REQUEST_REPORT_TO_DATE);
        this.fromDate = fromTime <= 0L ? null : new Date(fromTime);
        this.toDate = toTime <= 0L ? null : new Date(toTime);
    }

    public Object call() throws Exception {
        ReportRequestResponder responder;
        if (this.clazzPath == null) {
            OrderMate.LOG.warn("Invalid report request parameter:" + this.clazzPath);
        }
        if ((responder = ReportResponseFactory.getResponseFor(this.clazzPath)) != null) {
            responder.respondToReportRequest(this.fromDate, this.toDate);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

