/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.reportrequest;

import au.com.ordermate.oquery.SQLDateType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.reports.periodstock.PeriodStockAreaReportCreator;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.stock.StockTake;
import ordermate.hom.commandqueue.reportrequest.ReportRequestResponder;

public class PeriodStockResponder
extends ReportRequestResponder<PeriodStockAreaReportItem> {
    public PeriodStockResponder() {
        super(PeriodStockAreaReportItem.Properties.ADJUSTMENTS, PeriodStockAreaReportItem.Properties.PURCHASES, PeriodStockAreaReportItem.Properties.COGS, PeriodStockAreaReportItem.Properties.OPENING_STOCK, PeriodStockAreaReportItem.Properties.CLOSING_STOCK);
    }

    @Override
    protected Collection<PeriodStockAreaReportItem> findReports(Date from, Date to) {
        List<PeriodStockAreaReportItem> items;
        StockTake firstTake = null;
        StockTake lastTake = null;
        if (from == null) {
            firstTake = StockTake.getFirstStockTake();
            if (firstTake == null) {
                return Collections.emptyList();
            }
        } else {
            firstTake = StockTake.getFirstStockTakeForDate(from);
        }
        lastTake = to == null ? (firstTake != null ? firstTake.getNextStockTake() : StockTake.getLiveStockTake()) : StockTake.getLastStockTakeForDate(to, SQLDateType.TIMESTAMP);
        if (from != null && to != null || from != null && to == null && lastTake != null && lastTake.isLive()) {
            PeriodStockAreaReportCreator creator = new PeriodStockAreaReportCreator();
            items = creator.createAndCompileReports(firstTake, lastTake);
        } else {
            items = Collections.emptyList();
        }
        for (PeriodStockAreaReportItem nextItem : items) {
            nextItem.save();
        }
        return items;
    }

    @Override
    protected Date getNextValidDate(Date from, Date to) {
        StockTake lastTake = null;
        if (from == null && to == null) {
            lastTake = StockTake.getFirstStockTake();
            return lastTake != null ? lastTake.getDate() : null;
        }
        StockTake nextTake = null;
        lastTake = to == null ? StockTake.getLastStockTakeForDate(from, SQLDateType.TIMESTAMP) : StockTake.getLastStockTakeForDate(to, SQLDateType.TIMESTAMP);
        nextTake = lastTake == null ? StockTake.getFirstStockTake() : lastTake.getNextStockTake();
        return nextTake != null && !nextTake.isLive() ? nextTake.getDate() : null;
    }

    @Override
    protected Class<PeriodStockAreaReportItem> getVerifyingClazz() {
        return PeriodStockAreaReportItem.class;
    }
}

