/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.reportrequest;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.commandqueue.reportrequest.ReportRequestResponseHelper;
import ordermate.integration.webservice.RestHelper;

public abstract class ReportRequestResponder<T extends PersistentObject> {
    public static final String STORE_ID = "storeId";
    public static final String CLAZZ = "clazz";
    public static final String FROM_KEY = "fromDate";
    public static final String TO_KEY = "toDate";
    public static final String NEXT_DATE = "nextDate";
    public static final String REPORT_VERIFICATION = "synchronize/verification/verifyReports";
    private final ReportRequestResponseHelper<T> reportHelper;

    public ReportRequestResponder(PropertiedObject.Property ... propertiesToVerify) {
        this.reportHelper = new ReportRequestResponseHelper(propertiesToVerify);
    }

    protected ReportRequestResponseHelper<T> getHelper() {
        return this.reportHelper;
    }

    public void respondToReportRequest(final Date from, final Date to) {
        OrderMate.LOG.info("Asked for report " + this.getVerifyingClazz() + " from:" + from + " to:" + to);
        Runnable responseTask = new Runnable(){

            @Override
            public void run() {
                Collection reports = ReportRequestResponder.this.findReports(from, to);
                ReportRequestResponder.this.postBackVerification(reports, from, to);
            }
        };
        Thread thread = new Thread(responseTask);
        thread.start();
    }

    private void postBackVerification(Collection<T> reports, Date from, Date to) {
        RestHelper helper = new RestHelper();
        WebResource resource = helper.getResource(HOConfig.getInstance().getServerLocation() + REPORT_VERIFICATION);
        resource = helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), StoreGroup.getInstance().getStoreId().toString());
        resource = helper.addParameter(resource, STORE_ID, StoreGroup.getInstance().getStoreId().toString());
        resource = helper.addParameter(resource, CLAZZ, this.getVerifyingClazz().getCanonicalName());
        resource = helper.addParameter(resource, FROM_KEY, this.reportHelper.stringifyDate(from));
        resource = helper.addParameter(resource, TO_KEY, this.reportHelper.stringifyDate(to));
        Map<String, String> params = this.reportHelper.getVerificationParameters(reports);
        for (String key : params.keySet()) {
            resource = helper.addParameter(resource, key, params.get(key));
        }
        resource = helper.addParameter(resource, NEXT_DATE, this.reportHelper.stringifyDate(this.getNextValidDate(from, to)));
        OrderMate.LOG.info("Sending back verification parameters.");
        try {
            resource.post();
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.warn("Could not contact webservice for tradingday verification:", (Throwable)ex);
        }
    }

    protected abstract Collection<T> findReports(Date var1, Date var2);

    protected abstract Date getNextValidDate(Date var1, Date var2);

    protected abstract Class<T> getVerifyingClazz();
}

