/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.reportrequest;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;

public class ReportRequestResponseHelper<T extends PersistentObject> {
    private static final String PARAM_SEP = "!";
    private static final String PARAM_VAL = ":";
    public static final String ROW_IDS = "rowIds";
    public static final String CHECK_VALUE = "checkValue";
    private PropertiedObject.Property[] verifyingProperties;

    public ReportRequestResponseHelper(PropertiedObject.Property[] propertiesToVerify) {
        for (PropertiedObject.Property prop : this.verifyingProperties = propertiesToVerify) {
            if (Number.class.isAssignableFrom(prop.getObjectType())) continue;
            throw new IllegalArgumentException("Cannot perform a verification on a property that is not a Number:" + prop);
        }
    }

    public PropertiedObject.Property[] getVerifyingProperties() {
        PropertiedObject.Property[] props = new PropertiedObject.Property[this.verifyingProperties.length];
        System.arraycopy(this.verifyingProperties, 0, props, 0, this.verifyingProperties.length);
        return props;
    }

    public Map<String, String> getVerificationParameters(Collection<T> reports) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ROW_IDS, this.getRowIds(reports));
        params.put(CHECK_VALUE, this.getCheckValue(reports));
        return params;
    }

    private String getCheckValue(Collection<T> reports) {
        StringBuilder SB = new StringBuilder();
        for (PropertiedObject.Property property : this.verifyingProperties) {
            double tally = 0.0;
            try {
                Method method = property.getMethod();
                for (PersistentObject report : reports) {
                    Number nextNumber = (Number)method.invoke((Object)report, new Object[0]);
                    if (nextNumber == null) continue;
                    tally += nextNumber.doubleValue();
                }
                SB.append(property.getName()).append(PARAM_VAL).append(tally).append(PARAM_SEP);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot extract value from summary column:", (Throwable)ex);
            }
        }
        return SB.toString();
    }

    private String getRowIds(Collection<T> reports) {
        StringBuilder SB = new StringBuilder();
        for (PersistentObject nextT : reports) {
            SB.append(nextT.getID()).append(PARAM_SEP);
        }
        return SB.toString();
    }

    public String stringifyDate(Date value) {
        if (value == null) {
            return null;
        }
        return Long.toString(value.getTime());
    }

    public static Class decodeClass(String clazzString) {
        if (clazzString == null) {
            return null;
        }
        try {
            return Class.forName(clazzString);
        }
        catch (ClassNotFoundException ex) {
            OrderMate.LOG.error("Cannot handle report for class:" + clazzString, (Throwable)ex);
            return null;
        }
    }

    public static Date decodeDate(String dateString) {
        if (dateString != null && !dateString.equals("NULL")) {
            try {
                long value = Long.parseLong(dateString);
                return new Date(value);
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Cannot parse date string for verification:" + dateString);
            }
        }
        return null;
    }

    public static Map<String, Number> decodeCheckValues(String checkValues) {
        String[] splits;
        HashMap<String, Number> map = new HashMap<String, Number>();
        if (checkValues == null) {
            return Collections.emptyMap();
        }
        for (String split : splits = checkValues.split(PARAM_SEP)) {
            int index = split.indexOf(PARAM_VAL);
            String property = split.substring(0, index);
            String value = split.substring(index + 1, split.length());
            try {
                map.put(property, Double.valueOf(value));
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Cannot decipher check value, invalid:" + split, (Throwable)ex);
                map.put(property, null);
            }
        }
        return map;
    }

    public static Set<Long> decodeRowIds(String rowIds) {
        String[] splits;
        HashSet<Long> idSet = new HashSet<Long>();
        if (rowIds == null || rowIds.equalsIgnoreCase("null")) {
            return Collections.emptySet();
        }
        for (String split : splits = rowIds.split(PARAM_SEP)) {
            if (split.isEmpty()) continue;
            try {
                idSet.add(Long.valueOf(split));
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Cannot decipher row Ids, invalid:", (Throwable)ex);
            }
        }
        return idSet;
    }
}

