/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.rowrequest;

import au.com.ordermate.persistence.PersistentObject;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.integration.webservice.RestHelper;

class IDSender<T extends PersistentObject> {
    public static final String ID_VERIFICATION = "synchronize/verification/verifyIDs";
    private T rootObject;
    private List<PersistentObject> objects;

    IDSender(T theRoot, List<PersistentObject> allObjects) {
        this.rootObject = theRoot;
        this.objects = allObjects;
    }

    void sendOffIds() {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                String toSend = IDSender.this.getStringToSend();
                IDSender.this.sendList(toSend);
            }
        };
        new Thread(worker).start();
    }

    String getStringToSend() {
        LinkedHashMap clazzMap = new LinkedHashMap();
        for (PersistentObject obj : this.objects) {
            Class clazz = obj.getClass();
            if (!clazzMap.containsKey(obj.getClass())) {
                clazzMap.put(clazz, new ArrayList());
            }
            ((List)clazzMap.get(clazz)).add(obj.getID());
        }
        StringBuilder SB = new StringBuilder();
        for (Class clazz : clazzMap.keySet()) {
            this.insertIds(SB, clazz, (List)clazzMap.get(clazz));
        }
        return SB.toString();
    }

    private void insertIds(StringBuilder SB, Class clazz, List<Long> ids) {
        SB.append(clazz.getCanonicalName()).append("=");
        for (Long nextId : ids) {
            SB.append(nextId).append(" ");
        }
        SB.append(";\n");
    }

    private void sendList(String idValues) {
        RestHelper helper = new RestHelper();
        WebResource resource = helper.getResource(HOConfig.getInstance().getServerLocation() + ID_VERIFICATION);
        resource = helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), StoreGroup.getInstance().getStoreId().toString());
        resource = helper.addParameter(resource, "storeId", StoreGroup.getInstance().getStoreId().toString());
        resource = helper.addParameter(resource, "rootGroupClazz", String.valueOf(this.rootObject.getClass().getCanonicalName()));
        resource = helper.addParameter(resource, "rootGroupId", String.valueOf(((PersistentObject)this.rootObject).getID()));
        resource = helper.addParameter(resource, "allIDs", idValues);
        OrderMate.LOG.info("Sending back IDs for root object:" + ((PersistentObject)this.rootObject).getID());
        try {
            resource.post();
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.warn("Could not contact webservice for tradingday verification:", (Throwable)ex);
        }
    }
}

