/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.rowrequest;

import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistentObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;

public abstract class ResyncCascade<T extends PersistentObject> {
    private PersistenceDelegate delegate;
    private Map<Class, ResyncCascade> cascadeMap;
    private Set<PersistentObject> dodgyEntities;

    public ResyncCascade(PersistenceDelegate persistenceDelegate) {
        this.delegate = persistenceDelegate;
        this.cascadeMap = new HashMap<Class, ResyncCascade>();
        this.createCascadeResyncs(this.cascadeMap);
    }

    public Set<PersistentObject> getDodgyEntities() {
        if (this.dodgyEntities == null) {
            this.dodgyEntities = new HashSet<PersistentObject>();
        }
        for (ResyncCascade cascader : this.cascadeMap.values()) {
            this.dodgyEntities.addAll(cascader.getDodgyEntities());
        }
        return this.dodgyEntities;
    }

    protected PersistenceDelegate getDelegate() {
        return this.delegate;
    }

    public List<PersistentObject> getChildrenToCascade(T object) {
        List<PersistentObject> objects = null;
        try {
            objects = this.getChildObjects(object);
        }
        catch (Exception ex) {
            this.handleError((PersistentObject)object, ex);
        }
        if (objects == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<PersistentObject> mainList = new LinkedHashSet<PersistentObject>(objects);
        for (PersistentObject nextObj : objects) {
            Class<?> clazz = nextObj.getClass();
            if (!this.cascadeMap.containsKey(clazz)) {
                this.resolveResyncCascade(clazz);
            }
            if (this.cascadeMap.get(clazz) == null) continue;
            mainList.addAll(this.cascadeMap.get(clazz).getChildrenToCascade(nextObj));
        }
        return new ArrayList<PersistentObject>(mainList);
    }

    private void resolveResyncCascade(Class clazz) {
        ResyncCascade cascade = null;
        for (Class knownClazz : this.cascadeMap.keySet()) {
            if (!knownClazz.isAssignableFrom(clazz)) continue;
            cascade = this.cascadeMap.get(knownClazz);
        }
        if (cascade != null) {
            this.cascadeMap.put(clazz, cascade);
        }
    }

    private void handleError(PersistentObject value, Exception ex) {
        OrderMate.LOG.warn("Could not cascade children of object:" + value, (Throwable)ex);
        if (this.dodgyEntities == null) {
            this.dodgyEntities = new HashSet<PersistentObject>();
        }
        this.dodgyEntities.add(value);
    }

    protected abstract List<PersistentObject> getChildObjects(T var1);

    protected abstract void createCascadeResyncs(Map<Class, ResyncCascade> var1);
}

