/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.rowrequest;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncInterceptor;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.hom.commandqueue.rowrequest.IDSender;
import ordermate.hom.commandqueue.rowrequest.TradingDayCascade;
import ordermate.hom.synchronisation.LocalIdTranslator;

public class RowRequestResponder {
    private LocalIdTranslator translator = new LocalIdTranslator();

    public void respondToRowRequest(String clazzPath, Long rowId, Boolean cascade) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clazzPath);
        }
        catch (ClassNotFoundException ex) {
            OrderMate.LOG.error("Cannot send requested class, not found:", (Throwable)ex);
            return;
        }
        Long localId = this.translator.convertToLocalId(rowId);
        Object object = PersistenceManager.getByID(localId, clazz);
        if (object == null) {
            OrderMate.LOG.warn("Cannot send row. No ID:" + localId + " is found in the database for class :" + clazz);
            this.respondWithDelete(rowId, clazz);
            return;
        }
        OrderMate.LOG.info("Resending row data:" + clazzPath + " id:" + rowId + " cascade:" + cascade);
        if (cascade != null && cascade.booleanValue()) {
            this.respondWithCascade((PersistentObject)object);
        } else {
            this.respondNoCascade((PersistentObject)object);
        }
    }

    private void respondWithDelete(Long rowId, Class clazz) {
        try {
            PersistentObjectSnapshot snappy = new PersistentObjectSnapshot(clazz, 2);
            snappy.add(PersistentObject.Properties.ID, rowId);
            PersistenceSyncInterceptor interceptor = PersistenceSyncInterceptor.instance;
            if (interceptor != null) {
                interceptor.fireChange(snappy, PersistenceOperation.DELETE);
            } else {
                OrderMate.LOG.error("Cannot resync row without the interceptor.");
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot instantiate class to delete it:" + clazz, (Throwable)ex);
            return;
        }
    }

    private void respondWithCascade(PersistentObject object) {
        this.resyncObject(object);
        if (object instanceof TradingDay && !object.equals(TradingDay.getCurrentTradingDay())) {
            TradingDayCascade cascade = new TradingDayCascade(PersistenceManager.getPersistenceDelegate());
            TradingDay day = (TradingDay)object;
            List<PersistentObject> objects = cascade.getChildrenToCascade(day);
            this.resynchList(objects);
            new IDSender<TradingDay>(day, objects).sendOffIds();
        }
    }

    private void resynchList(final List<PersistentObject> objects) {
        OrderMate.LOG.info("Resynchronising list of objects:" + objects.size());
        new Thread(new Runnable(){

            @Override
            public void run() {
                int counter = 0;
                for (PersistentObject nextObject : objects) {
                    RowRequestResponder.this.resyncObject(nextObject);
                    if (++counter != 250) continue;
                    counter = 0;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        OrderMate.LOG.warn("Woken while waiting after synching a lot of objects.");
                    }
                }
            }
        }).start();
    }

    private void respondNoCascade(PersistentObject object) {
        this.resyncObject(object);
    }

    private void resyncObject(PersistentObject object) {
        try {
            PersistentObjectSnapshot snappy = object.getSnapshot();
            if (snappy != null) {
                PersistenceSyncInterceptor interceptor = PersistenceSyncInterceptor.instance;
                if (interceptor != null) {
                    interceptor.fireChange(snappy, PersistenceOperation.UPDATE);
                } else {
                    OrderMate.LOG.error("Cannot resync row without the interceptor.");
                }
            } else {
                OrderMate.LOG.error("Cannot get snapshot for object to resend.");
            }
        }
        catch (Throwable ex) {
            OrderMate.LOG.warn("Cannot resend data:", ex);
        }
    }
}

