/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.sync;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Message;
import javax.jms.TextMessage;
import ordermate.OrderMate;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageAction;
import ordermate.hom.commandqueue.actionImpl.AbstractMessageAction;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class SyncRequestAction
extends AbstractMessageAction {
    private static final String timeFormat = "HH:mm";
    private Signal endSignal = Signals.createSignal();
    private Date executionTime;
    private TextMessage messageParam;
    private TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            OrderMate.LOG.info("Performing scheduled resync action");
            SyncRequestAction.this.synchroniseHO(SyncRequestAction.this.endSignal);
        }
    };

    protected SyncRequestAction(MessageAction reply, InvalidMessageAction invalidMessage) {
        super(reply, invalidMessage);
    }

    protected TimerTask getTimerTask() {
        return this.timerTask;
    }

    @Override
    public void setParameter(Message param) throws Exception {
        if (!(param instanceof TextMessage)) {
            throw new IllegalArgumentException("Message for sync action is not a text message, cannot set parameter " + param);
        }
        this.messageParam = (TextMessage)param;
        this.executionTime = new SimpleDateFormat(timeFormat).parse(this.messageParam.getText());
    }

    public Object call() throws Exception {
        this.setCalled();
        Calendar scheduleTime = Calendar.getInstance();
        while (scheduleTime.get(12) != this.executionTime.getMinutes()) {
            scheduleTime.add(12, 1);
        }
        while (scheduleTime.get(11) != this.executionTime.getHours()) {
            scheduleTime.add(11, 1);
        }
        this.executionTime = scheduleTime.getTime();
        if (new Date().before(this.executionTime)) {
            this.endSignal.connect(this, "gotFinishedSync");
            OrderMate.LOG.info("Scheduling resync for :" + this.executionTime);
            new Timer().schedule(this.timerTask, this.executionTime);
        } else {
            OrderMate.LOG.warn("Could not schedule resync, execution time is in the past : " + this.executionTime);
            if (this.getInvalidAction() != null) {
                this.getInvalidAction().notifyError((Message)this.messageParam);
            }
        }
        return null;
    }

    protected abstract void synchroniseHO(Signal var1);

    protected void notifyError() {
        if (this.getInvalidAction() != null) {
            this.getInvalidAction().notifyError((Message)this.messageParam);
        }
    }

    protected void gotFinishedSync() {
        OrderMate.LOG.info("Scheduled resync complete");
        this.endSignal.disconnect(this);
        try {
            if (this.getReplyAction() != null) {
                this.getReplyAction().call();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Could not notify of success", (Throwable)ex);
        }
    }
}

