/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.sync;

import java.util.HashSet;
import java.util.TimerTask;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageAction;
import ordermate.hom.commandqueue.MessageActionFactory;
import ordermate.hom.commandqueue.sync.SyncRequestAction;

public abstract class SyncRequestActionFactory
implements MessageActionFactory {
    public static final String NAME = "COMMAND_RESYNC_REQUEST";
    private final HashSet<SyncRequestAction> pendingSyncTimerTasks = new HashSet();

    @Override
    public synchronized MessageAction createMessageAction(MessageAction callBackSuccess, InvalidMessageAction callBackFailure) {
        for (SyncRequestAction pendingAction : this.pendingSyncTimerTasks) {
            TimerTask task = pendingAction.getTimerTask();
            if (!task.cancel()) continue;
            pendingAction.notifyError();
        }
        this.pendingSyncTimerTasks.clear();
        SyncRequestAction action = this.createSyncRequestAction(callBackSuccess, callBackFailure);
        this.pendingSyncTimerTasks.add(action);
        return action;
    }

    protected abstract SyncRequestAction createSyncRequestAction(MessageAction var1, InvalidMessageAction var2);

    @Override
    public String getCommandName() {
        return NAME;
    }
}

