/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.verification.id;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.commandqueue.verification.VerificationMessageType;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.SyncQueueVendor;

class IDUpdateResponder {
    private final String tableName;
    private static final String TABLE_NAME_PLACE_HOLDER = "#TABLE_NAME#";
    private final String INDIVIDUAL_TABLE_QRY = "SELECT '#TABLE_NAME#' AS TABLE_NAME, MAX(ID) AS CURRENT_ID FROM #TABLE_NAME# WHERE ID < " + LocalIdTranslator.STORE_RANGE;
    private final String ALL_TABLE_QRY = "SELECT TABLE_NAME FROM information_schema.TABLES WHERE (TABLE_SCHEMA = 'ordermate_prod');";

    public IDUpdateResponder(String tableName) {
        this.tableName = tableName;
    }

    public boolean sendIDUpdateCommand() {
        Object[][] qryResults = this.tableName == null ? PersistenceManager.getPersistenceDelegate().executeQuery(this.getAllTablesQuery(), null) : PersistenceManager.getPersistenceDelegate().executeQuery(this.INDIVIDUAL_TABLE_QRY.replace(TABLE_NAME_PLACE_HOLDER, this.tableName), null);
        String response = this.buildResponseString(qryResults);
        SynchronisationSnapshot snapshot = new SynchronisationSnapshot(PersistenceOperation.DATA_VERIFICATION, "");
        snapshot.put("type", (Object)VerificationMessageType.TABLE_POS_ID);
        snapshot.put("tableToId", response);
        snapshot.put("store", StoreGroup.getInstance().getStoreId());
        return this.sendSnapShot(snapshot);
    }

    private String buildResponseString(Object[][] queryResults) {
        StringBuilder sb = new StringBuilder();
        for (Object[] tableId : queryResults) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(tableId[0]).append("=").append(tableId[1]);
        }
        return sb.toString();
    }

    private String getAllTablesQuery() {
        Object[][] qryTables = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT TABLE_NAME FROM information_schema.TABLES WHERE (TABLE_SCHEMA = 'ordermate_prod');", null);
        StringBuilder sb = new StringBuilder();
        for (Object[] tableNames : qryTables) {
            if (sb.length() != 0) {
                sb.append(" UNION ");
            }
            sb.append(this.INDIVIDUAL_TABLE_QRY.replace(TABLE_NAME_PLACE_HOLDER, (String)tableNames[0]));
        }
        return sb.toString();
    }

    boolean sendSnapShot(SynchronisationSnapshot snapshot) {
        try {
            SyncQueueVendor.getQueue(SyncQueueVendor.SyncQueueType.HeadOfficeVerification).add(snapshot);
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while attempting to send back the ID Update Snapshot", (Throwable)ex);
            return false;
        }
    }
}

