/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.verification.row;

import javax.jms.Message;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageAction;
import ordermate.hom.commandqueue.actionImpl.AbstractMessageAction;
import ordermate.hom.commandqueue.verification.row.HORowVerificationResponder;
import ordermate.hom.synchronisation.POSSnapshotFilter;

public class HORowVerificationAction
extends AbstractMessageAction {
    private static POSSnapshotFilter filter;
    public static final String PARAM_START_ID = "startId";
    public static final String PARAM_END_ID = "endId";
    public static final String PARAM_TABLE_NAME = "tableName";
    private String tableName;
    private long startId = -1L;
    private long endId = -1L;

    public HORowVerificationAction(MessageAction successAction, InvalidMessageAction invalidAction) {
        super(successAction, invalidAction);
    }

    @Override
    public void setParameter(Message param) throws Exception {
        this.tableName = param.getStringProperty(PARAM_TABLE_NAME);
        this.startId = param.getLongProperty(PARAM_START_ID);
        this.endId = param.getLongProperty(PARAM_END_ID);
    }

    public Object call() throws Exception {
        if (HOConfig.getInstance().isHoLite()) {
            if (filter == null) {
                filter = new POSSnapshotFilter();
            }
            if (!filter.isSynchronisable(this.tableName)) {
                OrderMate.LOG.info("HO-Lite will not synchronize table " + this.tableName);
                return Boolean.TRUE;
            }
        }
        return new HORowVerificationResponder(this.tableName, this.startId, this.endId).sendRowVerification();
    }
}

