/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.verification.row;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.commandqueue.verification.VerificationMessageType;
import ordermate.hom.commandqueue.verification.row.IDModCountHelper;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.SyncQueueVendor;

class HORowVerificationResponder {
    private String tableName;
    private long startId;
    private long endId;
    private LocalIdTranslator translator = new LocalIdTranslator();
    private static final long ID_NOT_SET = -1L;

    public HORowVerificationResponder(String tableName, long startId, long endId) {
        this.tableName = tableName;
        this.startId = this.translator.convertToLocalId(startId);
        this.endId = this.translator.convertToLocalId(endId);
        if (endId == -1L) {
            this.endId = LocalIdTranslator.STORE_RANGE - 1L;
        }
    }

    public boolean sendRowVerification() {
        Object[][] results = null;
        try {
            results = IDModCountHelper.getIDModCountQueryResults(this.tableName, this.startId, this.endId);
        }
        catch (Exception ex) {
            if (Config.isDebuging()) {
                OrderMate.LOG.warn("Cannot get id count for table:" + this.tableName + ", doesn't exist at POS.");
            }
            return true;
        }
        StringBuilder sb = new StringBuilder();
        int numResults = 0;
        long batchStartId = this.startId == 0L ? 0L : -1L;
        long batchEndId = -1L;
        boolean result = true;
        int LIMIT = HOConfig.getInstance().getMaxIdsPerVerMsg();
        for (Object[] rowResult : results) {
            ++numResults;
            if (batchStartId == -1L) {
                batchStartId = (Long)rowResult[0];
            }
            batchEndId = numResults == results.length ? this.endId : (Long)rowResult[0];
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(rowResult[0]).append("=").append(rowResult[1]);
            if (numResults % LIMIT != 0) continue;
            if (!this.sendRowVerificationSnapshot(sb.toString(), batchStartId, batchEndId) && result) {
                result = false;
            }
            batchStartId = -1L;
            batchEndId = -1L;
            sb.setLength(0);
        }
        if (sb.length() > 0 && !this.sendRowVerificationSnapshot(sb.toString(), batchStartId, batchEndId) && result) {
            result = false;
        }
        return result;
    }

    private boolean sendRowVerificationSnapshot(String idModPairs, long batchStartId, long batchEndId) {
        try {
            SynchronisationSnapshot fakeSnappy = new SynchronisationSnapshot(PersistenceOperation.DATA_VERIFICATION, "");
            fakeSnappy.put("idMod", idModPairs);
            fakeSnappy.put("store", StoreGroup.getInstance().getStoreId());
            fakeSnappy.put("table", this.tableName);
            fakeSnappy.put("type", VerificationMessageType.ID_MOD_COUNT_VER_MSG.toString());
            fakeSnappy.put("startId", this.translator.convertToHOId(batchStartId));
            fakeSnappy.put("endId", this.translator.convertToHOId(batchEndId));
            SyncQueueVendor.getQueue(SyncQueueVendor.SyncQueueType.HeadOfficeVerification).add(fakeSnappy);
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while attempting to send back the Verification Snapshot", (Throwable)ex);
            return false;
        }
    }
}

