/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.verification.row;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.HashMap;
import java.util.Map;
import ordermate.hom.synchronisation.LocalIdTranslator;

public class IDModCountHelper {
    private static final String TABLE_PARAM_STR = "?TABLE?";
    private static final String SQL_FETCH_QUERY = "SELECT ID, mod_count FROM ?TABLE? WHERE (ID >= ?) AND (ID <= ?)";
    private static final String SQL_STORE_ID_CONDITION = " AND (store_id = ?)";
    private static final String SQL_ORDER_BY_ID = " ORDER BY ID";
    private static final String SQL_FETCH_QUERY_LEAST_STORE_LEVEL_FITLER_CONDITION = "SELECT ID, mod_count FROM ?TABLE? WHERE (ID >= ?) AND (ID <= LEAST(?, ?))";

    public static Map<Long, Long> getIDModCountMap(String rawIdToModCount) {
        String[] idToModStrings;
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>();
        for (String idModStr : idToModStrings = rawIdToModCount.split(",")) {
            String[] idAndMod = idModStr.split("=");
            if (idAndMod.length != 2) continue;
            resultMap.put(Long.valueOf(idAndMod[0]), Long.valueOf(idAndMod[1]));
        }
        return resultMap;
    }

    public static Map<Long, Long> getIDModCountMap(Object[][] idModCountQueryResult) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>();
        if (idModCountQueryResult != null) {
            for (Object[] idAndMod : idModCountQueryResult) {
                resultMap.put((Long)idAndMod[0], (Long)idAndMod[1]);
            }
        }
        return resultMap;
    }

    public static Object[][] getIDModCountQueryResults(String tableName, long startId, long endId) {
        String baseQuery = SQL_FETCH_QUERY_LEAST_STORE_LEVEL_FITLER_CONDITION.replace(TABLE_PARAM_STR, tableName) + SQL_ORDER_BY_ID;
        return PersistenceManager.getPersistenceDelegate().executeQuery(baseQuery, new Object[]{startId, endId, LocalIdTranslator.STORE_RANGE});
    }

    public static Object[][] getIDModCountQueryResults(String tableName, long startId, long endId, long storeId) {
        String baseQuery = SQL_FETCH_QUERY.replace(TABLE_PARAM_STR, tableName) + SQL_STORE_ID_CONDITION + SQL_ORDER_BY_ID;
        return PersistenceManager.getPersistenceDelegate().executeQuery(baseQuery, new Object[]{startId, endId, storeId});
    }
}

