/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.verification.tradingday;

import java.util.concurrent.Semaphore;
import javax.jms.Message;
import ordermate.OrderMate;
import ordermate.hom.commandqueue.InvalidMessageAction;
import ordermate.hom.commandqueue.MessageAction;
import ordermate.hom.commandqueue.actionImpl.AbstractMessageAction;
import ordermate.hom.commandqueue.verification.tradingday.OrdermateVerifier;

public class HOVerificationAction
extends AbstractMessageAction {
    public static final String PROPERTY_TRADING_DAY_ID = "tradingDayId";
    public static final String PROPERTY_TRADING_DAY_SALES = "totalSales";
    private Long tradingDayId;
    private static final Semaphore talkingStick = new Semaphore(1);
    private static final String TRADING_DAY = "TradingDayVerification";

    public HOVerificationAction(MessageAction successAction, InvalidMessageAction invalidAction) {
        super(successAction, invalidAction);
    }

    public Object call() throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean goAhead = false;
                if (talkingStick.tryAcquire()) {
                    try {
                        OrderMate.LOG.info("Received notification to verify a trading day:" + HOVerificationAction.this.tradingDayId);
                        OrdermateVerifier verifier = new OrdermateVerifier();
                        verifier.respondToTradingDayVerification(HOVerificationAction.this.tradingDayId);
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Could not respond to verification request:", (Throwable)ex);
                    }
                    finally {
                        talkingStick.release();
                    }
                }
            }
        };
        new Thread(runnable).start();
        return Boolean.TRUE;
    }

    @Override
    public void setParameter(Message param) throws Exception {
        this.tradingDayId = param.getLongProperty(PROPERTY_TRADING_DAY_ID);
    }
}

