/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.verification.tradingday;

import au.com.ordermate.oquery.GroupBy;
import au.com.ordermate.persistence.PersistenceManager;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.searchers.reports.AccountTotalsReportSearcher;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.integration.webservice.RestHelper;

public class OrdermateVerifier {
    public static final String VERIFIER_TERMINATOR = "!";
    public static final String TRADING_DAY_VERIFICATION = "synchronize/verification/verifyTradingDay";
    public static final String VERIFIER_SEPARATOR = ":";

    public void respondToTradingDayVerification(Long tradingDayId) {
        RestHelper helper = new RestHelper();
        LocalIdTranslator translator = new LocalIdTranslator();
        Long localId = translator.convertToLocalId(tradingDayId);
        TradingDay day = PersistenceManager.getByID(localId, TradingDay.class);
        if (day == null) {
            OrderMate.LOG.warn("Trading day ID does not correspond to anything I have:" + localId);
            return;
        }
        AccountTotalsReportSearcher searcher = new AccountTotalsReportSearcher(new GroupBy(Account.Properties.ACCOUNT_TYPE), false);
        searcher.getTradingDayFilter().setSearchValue(day);
        List<AccountTotalsReport> reports = searcher.search();
        Map<String, String> paramMap = this.getVerificationParameters(reports);
        WebResource resource = helper.getResource(HOConfig.getInstance().getServerLocation() + TRADING_DAY_VERIFICATION);
        resource = helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), StoreGroup.getInstance().getStoreId().toString());
        resource = helper.addParameter(resource, "storeId", StoreGroup.getInstance().getStoreId().toString());
        resource = helper.addParameter(resource, "tradingDayId", String.valueOf(tradingDayId));
        StringBuilder SB = new StringBuilder();
        for (String key : paramMap.keySet()) {
            SB.append(key + VERIFIER_SEPARATOR + paramMap.get(key) + VERIFIER_TERMINATOR);
        }
        resource = helper.addParameter(resource, "totalSales", SB.toString());
        OrderMate.LOG.info("Sending back verification parameters.");
        try {
            resource.post();
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.warn("Could not contact webservice for tradingday verification:", (Throwable)ex);
        }
    }

    public Map<String, String> getVerificationParameters(List<AccountTotalsReport> reports) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!reports.isEmpty()) {
            for (AccountTotalsReport report : reports) {
                params.put(report.getAccountType() + "-" + report.getAccountState(), String.valueOf(report.getTotal()));
            }
        }
        return params;
    }
}

