/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.commandqueue.webresource;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.integration.webservice.RestHelper;
import org.apache.logging.log4j.Level;

public class HOWebNotifier {
    public static final String MENU_CAT = "Menu";
    private static final Integer CONNECT_TIMEOUT = 5000;
    private static final Integer TIMEOUT = 5000;
    private static final String NOTIFICATIONS = "synchronize/notification/pos/";
    private RestHelper restHelper;
    private Semaphore latch = new Semaphore(1);
    private static HOWebNotifier instance;

    private HOWebNotifier() {
        this.restHelper = new RestHelper();
    }

    public static HOWebNotifier getInstance() {
        if (instance == null) {
            instance = new HOWebNotifier();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyHeadOffice(String category, String what, String extra) {
        try {
            this.latch.tryAcquire(1, TIMEOUT.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            OrderMate.LOG.log(Level.WARN, "Interrupted while waiting for HO Notification Latch", (Throwable)ex);
        }
        try {
            String url = HOConfig.getInstance().getServerLocation();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + NOTIFICATIONS + StoreGroup.getInstance().getStoreId().toString();
            WebResource resource = this.restHelper.getResource(url, CONNECT_TIMEOUT, TIMEOUT);
            resource = this.restHelper.addBasicAuth(resource, StoreGroup.getInstance().getStoreId().toString(), StoreGroup.getInstance().getStoreName());
            Form form = new Form();
            form.add("notification", what);
            if (extra != null) {
                form.add("extra", extra);
            }
            if (category != null) {
                form.add("category", category);
            }
            ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type("application/x-www-form-urlencoded").accept(new String[]{"text/plain"})).post(ClientResponse.class, (Object)form);
            String entity = (String)response.getEntity(String.class);
            if (response != null && response.getStatus() / 100 == 2) {
                OrderMate.LOG.log(Level.WARN, "Uploaded notification to head office " + response.getStatus() + " " + entity);
                boolean bl = true;
                return bl;
            }
            OrderMate.LOG.log(Level.WARN, "Cannot upload notification to " + url + " status:" + response.getStatus() + " cause:" + entity);
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.WARN, "Cannot upload notification", (Throwable)ex);
        }
        finally {
            this.latch.release();
        }
        return false;
    }
}

