/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.jms;

import au.com.ordermate.configuration.Config;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

abstract class JMSConnectionService {
    private static final long RETRY_DELAY = 600000L;
    private final String subject;
    private Connection connection;
    private Session session;
    private boolean durableTopic;

    public JMSConnectionService(String msgQueueSubject) {
        this(msgQueueSubject, false);
    }

    public JMSConnectionService(String msgQueueSubject, boolean isDurableTopic) {
        this.subject = msgQueueSubject;
        this.durableTopic = isDurableTopic;
    }

    protected void createSessionObject() throws JMSException {
        this.session = this.getConnection().createSession(false, 1);
    }

    public Connection createConnection() {
        String url;
        String password;
        String user = Config.getStringValue("jms_user");
        if (user == null || user.isEmpty()) {
            user = ActiveMQConnection.DEFAULT_USER;
        }
        if ((password = Config.getStringValue("jms_password")) == null || password.isEmpty()) {
            password = ActiveMQConnection.DEFAULT_PASSWORD;
        }
        if ((url = Config.getStringValue("jms_url")) == null || url.isEmpty()) {
            url = "failover://tcp://localhost:61616?wireFormat.maxInactivityDuration=600000";
        }
        try {
            OrderMate.LOG.info("Connecting to URL: " + url);
            OrderMate.LOG.info("Attempting to connect to the queue: " + this.subject);
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(user, password, url);
            while (this.connection == null) {
                try {
                    if (!this.durableTopic) {
                        this.connection = connectionFactory.createConnection();
                    } else {
                        connectionFactory.setClientID(this.subject + StoreGroup.getInstance().getStoreId());
                        this.connection = connectionFactory.createTopicConnection();
                    }
                    this.connection.start();
                    OrderMate.LOG.info("JMS Queue successfully connected to : " + this.subject);
                }
                catch (JMSException e) {
                    OrderMate.LOG.warn("Could not connect to " + url, e.getCause());
                }
                catch (Exception e) {
                    OrderMate.LOG.warn("Error into the ActiveMQ component", (Throwable)e);
                }
                if (this.connection != null) continue;
                String msg = "Could not create connection, sleeping for 600secs, will retry after.";
                System.out.println(msg);
                OrderMate.LOG.warn("Could not create connection, sleeping for 600secs, will retry after.");
                Thread.sleep(600000L);
            }
        }
        catch (InterruptedException ex) {
            OrderMate.LOG.warn("Interrupted while aquiring the JMS Queue.");
        }
        catch (Throwable t) {
            OrderMate.LOG.fatal("Unable to use JMS", t);
        }
        return this.connection;
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException ex) {
                OrderMate.LOG.warn((Object)ex);
            }
        }
        this.connection = null;
    }

    protected Session getSession() {
        if (this.session == null) {
            throw new IllegalStateException("Session has not been created");
        }
        return this.session;
    }

    protected Connection getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("Connection has not been created.");
        }
        return this.connection;
    }

    public String getSubject() {
        return this.subject;
    }

    protected void closeSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException ex) {
                OrderMate.LOG.warn((Object)ex);
            }
            this.session = null;
        }
    }

    public boolean isConnectionValid() {
        return this.connection != null;
    }

    protected Destination createDestination() throws JMSException {
        return this.getSession().createQueue(this.getSubject());
    }
}

