/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.jms;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import ordermate.hom.jms.JMSConnectionService;

public class JMSConsumerService
extends JMSConnectionService {
    private MessageConsumer consumer;

    public JMSConsumerService(String msgQueueSubject) {
        super(msgQueueSubject);
    }

    public JMSConsumerService(String msgQueueSubject, boolean durable) {
        super(msgQueueSubject, durable);
    }

    public void createConsumer() throws JMSException {
        this.createConsumer(false);
    }

    public void createConsumer(boolean durable) throws JMSException {
        this.createSessionObject();
        this.consumer = !durable ? this.getSession().createConsumer(this.createDestination()) : this.getSession().createDurableSubscriber(this.getSession().createTopic(this.getSubject()), this.getSubject());
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.consumer == null) {
            throw new IllegalStateException("Must call create consumer before attempting to set the message listener");
        }
        this.consumer.setMessageListener(listener);
    }

    public MessageConsumer getMessageConsumer() {
        return this.consumer;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.getConnection().setExceptionListener(listener);
    }
}

