/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.jms;

import au.com.ordermate.configuration.Config;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.jms.JMSConnectionService;

public class JMSProducerService
extends JMSConnectionService {
    private static final String STORE = "store";
    private static final String COUNTER = "counter";
    private MessageProducer messageProducer;
    private long store;
    private int sequenceCounter = 1;

    public JMSProducerService(String subject) {
        super(subject);
        if (StoreGroup.getInstance().getStoreId() == 0L && Config.isDebuging()) {
            OrderMate.LOG.warn("NO STORE ID HAS BEEN SET. Default value 1 applied for testing.");
            StoreGroup.getInstance().setStoreId(1L);
            StoreGroup.getInstance().save();
        }
        this.store = StoreGroup.getInstance().getStoreId();
        if (this.store == 0L) {
            OrderMate.LOG.warn("The store id is not set, cannot synchronise HeadOfficeMate.");
            return;
        }
    }

    public void createProducer() throws JMSException {
        super.createSessionObject();
        this.messageProducer = this.getSession().createProducer(this.createDestination());
        this.messageProducer.setDeliveryMode(2);
    }

    public MessageProducer getMessageProducer() {
        if (this.messageProducer == null) {
            throw new IllegalStateException("Must call create producer before getMessageProducer");
        }
        return this.messageProducer;
    }

    public boolean isValidProducer() {
        return this.messageProducer != null;
    }

    public void closeProducer() {
        if (this.messageProducer != null) {
            try {
                this.messageProducer.close();
            }
            catch (JMSException ex) {
                OrderMate.LOG.warn((Object)ex);
            }
            this.messageProducer = null;
        }
        super.closeSession();
    }

    public void sendObjectMessage(Serializable obj, int priority) throws JMSException {
        ObjectMessage message = this.getSession().createObjectMessage(obj);
        message.setJMSPriority(priority);
        this.sendMessage((Message)message);
    }

    public void sendTextMessage(String msg) throws JMSException {
        TextMessage message = this.getSession().createTextMessage(msg);
        this.sendMessage((Message)message);
    }

    public void sendMessage(Message msg) throws JMSException {
        this.fillOutStandardParams(msg);
        this.getMessageProducer().send(msg);
    }

    private void fillOutStandardParams(Message message) throws JMSException {
        message.setLongProperty(STORE, this.store);
        message.setStringProperty("JMSXGroupID", Long.toString(this.store));
        int counter = this.incrementCounter();
        message.setIntProperty(COUNTER, counter);
    }

    @Override
    public Session getSession() {
        return super.getSession();
    }

    private int incrementCounter() {
        this.sequenceCounter = this.sequenceCounter == Integer.MAX_VALUE ? -1 : ++this.sequenceCounter;
        return this.sequenceCounter;
    }
}

