/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.jms;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import ordermate.OrderMate;
import ordermate.hom.jms.JMSConsumerService;

public abstract class TopicSubscriber
implements Runnable,
ExceptionListener {
    private static final int RETRY = 660000;
    private JMSConsumerService jmsService;
    private MessageListener listener = this.createMessageListener();

    public TopicSubscriber() {
        OrderMate.LOG.info("Subscribing to HO Topic:" + this.getTopic());
    }

    protected abstract MessageListener createMessageListener();

    protected abstract String getTopic();

    @Override
    public void run() {
        this.jmsService = new JMSConsumerService(this.getTopic(), true);
        this.jmsService.createConnection();
        if (!this.jmsService.isConnectionValid()) {
            return;
        }
        try {
            this.jmsService.setExceptionListener(this);
            this.jmsService.createConsumer(true);
            this.jmsService.setMessageListener(this.listener);
        }
        catch (JMSException jmsEx) {
            this.onException(jmsEx);
        }
    }

    public void onException(JMSException ex) {
        OrderMate.LOG.warn("JMS Exception in topic queue, will sleep for 11 mins, and retry", (Throwable)ex);
        try {
            if (this.jmsService.isConnectionValid()) {
                this.jmsService.closeConnection();
            }
        }
        catch (Exception ex1) {
            OrderMate.LOG.info("Error closing JMS connection.", (Throwable)ex1);
        }
        try {
            Thread.sleep(660000L);
            new Thread(this).start();
        }
        catch (InterruptedException intEx) {
            OrderMate.LOG.info("Topic thread interrupted while awaiting retry, exiting.", (Throwable)intEx);
        }
        catch (Exception exAll) {
            OrderMate.LOG.info("Error while restarting the topic " + this.getTopic(), (Throwable)exAll);
        }
    }
}

