/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.course.SalesAccountCourse;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.WebResourceLog;
import ordermate.database.misc.WebResourceLogExt;
import ordermate.database.misc.license.License;
import ordermate.database.reports.StoreGroupMonthlySales;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.derived.DerivedReportColumn;
import ordermate.database.reports.config.custom.column.direct.DirectReportColumn;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.sales.CustomerPoints;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.stock.StockItem;
import ordermate.database.workflow.Workflow;
import ordermate.hom.synchronisation.AbstractSnapshotFilter;
import ordermate.hom.synchronisation.SnapshotFilter;

public abstract class AbstractPosSnapshotFilter
extends AbstractSnapshotFilter {
    protected static final Package[] EXCLUDED_PACKAGES = new Package[]{StockItem.class.getPackage(), Workflow.class.getPackage(), CustomReport.class.getPackage(), InventoryCoupon.class.getPackage(), CustomReport.class.getPackage(), CustomReportColumn.class.getPackage(), DirectReportColumn.class.getPackage(), DerivedReportColumn.class.getPackage()};
    protected static final Class[] EXCLUDED_CLASSES = new Class[]{AbstractDocket.class, SalesAccountDocket.class, SalesAccountCourse.class, License.class, EventLogRecord.class, StoreGroupMonthlySales.class, SystemCurrentInfo.class, CustomerPoints.class, DayPart.class, SalesCoupon.class, WebResourceLog.class, WebResourceLogExt.class, OnlineIntegrationETA.class, ExperimentalFeature.class};
    protected static final Class[] INCLUDED_CLASSES = new Class[]{PeriodStockAreaReportItem.class};
    protected final Set<Package> excludedPackages = new HashSet<Package>(Arrays.asList(EXCLUDED_PACKAGES));
    protected final Set<Class> excludedClasses = new HashSet<Class>(Arrays.asList(EXCLUDED_CLASSES));
    protected final Set<Class> cachedIncludedClasses = new HashSet<Class>(Arrays.asList(INCLUDED_CLASSES));
    protected final Set<PropertiedObject.Property> excludedProperties = new HashSet<PropertiedObject.Property>();
    protected final Map<Class, SnapshotFilter> conditionalFilters = new HashMap<Class, SnapshotFilter>();
    protected boolean primed = false;

    public AbstractPosSnapshotFilter() {
        this.primeCache();
    }

    protected abstract void primeCache();

    @Override
    public boolean isSynchronisable(PersistentObjectSnapshot snapshot) {
        boolean fine = super.isSynchronisable(snapshot);
        fine = fine && this.isConditionallyIncluded(snapshot);
        return fine;
    }

    @Override
    public boolean isSynchronisable(Class entity) {
        if (this.cachedIncludedClasses.contains(entity)) {
            return true;
        }
        if (!this.primed && this.isSynchronisableNoCache(entity)) {
            this.cachedIncludedClasses.add(entity);
            return true;
        }
        return false;
    }

    protected boolean isSynchronisableNoCache(Class entity) {
        if (this.excludedPackages.contains(entity.getPackage())) {
            return false;
        }
        if (this.excludedClasses.contains(entity)) {
            return false;
        }
        if (Modifier.isAbstract(entity.getModifiers())) {
            return false;
        }
        if (!PersistentObject.class.isAssignableFrom(entity) || PersistentSummaryObject.class.isAssignableFrom(entity)) {
            return false;
        }
        return entity.isAnnotationPresent(Entity.class);
    }

    @Override
    public boolean isPropertySynchronisable(PropertiedObject.Property property) {
        return !this.excludedProperties.contains(property);
    }

    private boolean isConditionallyIncluded(PersistentObjectSnapshot snapshot) {
        if (this.conditionalFilters.containsKey(snapshot.getObjectType())) {
            return this.conditionalFilters.get(snapshot.getObjectType()).isSynchronisable(snapshot);
        }
        return true;
    }
}

