/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SyncPersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncReceiver;
import au.com.ordermate.persistence.synchronisation.PosPersistentObjectCreator;
import au.com.ordermate.persistence.synchronisation.PrePersistInterceptor;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.synchronisation.IdTranslator;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.integration.webservice.RestHelper;

public class BusinessObjectRequestor {
    public static final String BUSINESS_OBJ_PATH = "synchronize/fetchBusinessObject/";
    public static final String PARAM_ID = "id";
    public static final String PARAM_CLASSNAME = "className";
    public static final String PARAM_ID_PROPERTY = "idProperty";
    private final PosPersistentObjectCreator creator;
    private final RestHelper helper;
    private final IdTranslator translator;
    private static final int FETCH_TIMEOUT_CONNECTION = 2000;
    private static final int FETCH_TIMEOUT_RESPONSE = 5000;
    private PrePersistInterceptor prePersistSnapshotInterceptor = null;

    public BusinessObjectRequestor(RestHelper helper, PosPersistentObjectCreator creator) {
        this.helper = helper;
        this.creator = creator;
        this.translator = new LocalIdTranslator();
    }

    public BusinessObjectRequestor(RestHelper helper, PosPersistentObjectCreator creator, PrePersistInterceptor preProcessor) {
        this(helper, creator);
        this.prePersistSnapshotInterceptor = preProcessor;
    }

    public boolean fetch(PropertiedObject.Property propToCheck, Class<? extends PersistentObject> clazz, SynchronisationSnapshot snapshot, PropertiedObject.Property idProperty) {
        Long id = (Long)snapshot.get(propToCheck.getName());
        PersistentObject object = this.fetch(id, clazz, idProperty);
        if (object != null) {
            snapshot.put(propToCheck.getName(), object.getID());
        }
        return object != null;
    }

    public <T extends PersistentObject> T fetch(Long id, Class<T> clazz, PropertiedObject.Property idProperty) {
        if (id == null) {
            OrderMate.LOG.warn("Cannot find a " + clazz + " with a null id.");
            return null;
        }
        T object = this.getExisting(id, clazz, idProperty);
        if (object != null) {
            return object;
        }
        StringBuilder sb = new StringBuilder(HOConfig.getInstance().getServerLocation()).append(BUSINESS_OBJ_PATH);
        WebResource resource = this.helper.getResource(sb.toString(), 2000, 5000);
        resource = this.helper.addBasicAuth(resource, "" + StoreGroup.getInstance().getStoreId(), StoreGroup.getInstance().getStoreName());
        resource = this.helper.addParameter(resource, PARAM_ID, id.toString());
        resource = this.helper.addParameter(resource, PARAM_CLASSNAME, clazz.getCanonicalName());
        resource = this.helper.addParameter(resource, PARAM_ID_PROPERTY, idProperty.getName());
        OrderMate.LOG.info("Attempting to download " + clazz + " from: " + resource + " of id " + id);
        try {
            SynchronisationSnapshot objSnapShot = this.helper.getObject(resource, SynchronisationSnapshot.class);
            if (objSnapShot != null) {
                this.processObjectSnapShot(objSnapShot, true);
                OrderMate.LOG.info("Processed snapshot for class: " + clazz.getName() + ", with ID: " + id);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot get customer snapshot", (Throwable)ex);
        }
        return this.getExisting(id, clazz, idProperty);
    }

    private void processObjectSnapShot(SynchronisationSnapshot snapshot, boolean isNew) {
        OrderMate.LOG.info("Processing snapshot:" + snapshot);
        PersistentObject persistentObj = this.creator.createFromSnapShotContent(snapshot);
        if (this.prePersistSnapshotInterceptor != null) {
            this.prePersistSnapshotInterceptor.prepareForSave(persistentObj);
        }
        this.saveToDB(persistentObj, isNew);
    }

    private <T extends PersistentObject> void saveToDB(T object, boolean isNew) {
        try {
            SyncPersistentObjectSnapshot snapShot = object.getSnapshot();
            if (isNew) {
                snapShot = new SyncPersistentObjectSnapshot(snapShot);
            }
            PersistenceSyncReceiver.getInstance().saveOrUpdate(snapShot);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't save or update " + object.getClass() + " incoming from HO: ", (Throwable)ex);
        }
    }

    private <T extends PersistentObject> T getExisting(Long id, Class<T> clazz, PropertiedObject.Property idProperty) {
        if (PersistentObject.Properties.ID.equals(idProperty)) {
            return PersistenceManager.getByID(this.translator.convertToLocalId(id), clazz);
        }
        return (T)((PersistentObject)PersistenceManager.getObject(clazz, Query.select(clazz).equals(idProperty, id).toString(), null));
    }
}

