/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.synchronisation.PosPersistentObjectCreator;
import ordermate.OrderMate;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerPoints;
import ordermate.hom.synchronisation.BusinessObjectRequestor;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.customer.CustomerCategoryConverter;
import ordermate.hom.synchronisation.customer.CustomerPointsConverter;
import ordermate.integration.webservice.RestHelper;

public class BusinessObjectRequestorExecuter<T extends PersistentObject>
extends Executable<T> {
    private long id;
    private Class<T> clazz;
    private PropertiedObject.Property idProperty;

    public BusinessObjectRequestorExecuter(long id, Class<T> clazz, PropertiedObject.Property idProperty) {
        this.id = id;
        this.clazz = clazz;
        this.idProperty = idProperty;
    }

    @Override
    public T execute() {
        try {
            RestHelper helper = new RestHelper();
            LocalIdTranslator translator = new LocalIdTranslator();
            PosPersistentObjectCreator creator = new PosPersistentObjectCreator(translator);
            creator.setConverter(CustomerCategory.class, new CustomerCategoryConverter());
            creator.setConverter(CustomerPoints.class, new CustomerPointsConverter());
            BusinessObjectRequestor requestor = new BusinessObjectRequestor(helper, creator);
            return requestor.fetch(this.id, this.clazz, this.idProperty);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error fetching the class: " + this.clazz + " with id: " + this.id + " via BusinessObjectRequestor.", (Throwable)ex);
            return null;
        }
    }
}

